/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.h2;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.util.om.OMPlatform;

public class H2Adapter
extends DBAdapter {
    private static final String NAME = "h2";
    public static final String VERSION = String.valueOf("2.4.240");
    private static final boolean LOWER_CASE_SCHEMA_NAME = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.db.h2.H2Adapter.LOWER_CASE_SCHEMA_NAME");
    private static final String DEFAULT_SCHEMA_NAME = LOWER_CASE_SCHEMA_NAME ? "public" : "PUBLIC";

    public H2Adapter() {
        super(NAME, VERSION);
    }

    protected H2Adapter(String name, String version) {
        super(name, version);
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BIT: {
                return "SMALLINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case LONGVARCHAR: {
                return "VARCHAR";
            }
            case NUMERIC: {
                return "DECIMAL";
            }
            case VARBINARY: 
            case LONGVARBINARY: 
            case BLOB: {
                return "BINARY LARGE OBJECT";
            }
            case CLOB: {
                return "CHARACTER LARGE OBJECT";
            }
        }
        return super.getTypeName(field);
    }

    public String getDefaultSchemaName(Connection connection) {
        return DEFAULT_SCHEMA_NAME;
    }

    public String[] getReservedWords() {
        return this.getSQL92ReservedWords();
    }

    protected boolean isPrimaryKeyShadow(Connection connection, IDBTable table, String name, IDBIndex.Type type, IDBField[] fields) {
        if (!name.toUpperCase().startsWith("PRIMARY_KEY")) {
            return false;
        }
        return super.isPrimaryKeyShadow(connection, table, name, type, fields);
    }

    public boolean isDuplicateKeyException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "23001".equals(sqlState) || "23505".equals(sqlState);
    }

    public boolean isTableNotFoundException(SQLException ex) {
        int errorCode = ex.getErrorCode();
        switch (errorCode) {
            case 42102: 
            case 42103: 
            case 42104: {
                return true;
            }
        }
        return false;
    }

    public String sqlRenameField(IDBField field, String oldName) {
        return "ALTER TABLE " + field.getTable() + " ALTER COLUMN " + oldName + " RENAME TO " + field;
    }

    protected String sqlCharIndexFunction() {
        return "LOCATE";
    }

    public static void createSchema(DataSource dataSource, final String name, final boolean dropIfExists) {
        DBUtil.execute((IDBConnectionProvider)DBUtil.createConnectionProvider((DataSource)dataSource), (DBUtil.RunnableWithConnection)new DBUtil.RunnableWithConnection<Object>(){

            public Object run(Connection connection) throws SQLException {
                if (dropIfExists) {
                    DBUtil.execute((Connection)connection, (CharSequence)("DROP SCHEMA IF EXISTS " + DBUtil.quoted((String)name) + " CASCADE"));
                }
                DBUtil.execute((Connection)connection, (CharSequence)("CREATE SCHEMA IF NOT EXISTS " + DBUtil.quoted((String)name)));
                return null;
            }
        });
    }

    public static void shutdown(DataSource dataSource) {
        DBUtil.execute((IDBConnectionProvider)DBUtil.createConnectionProvider((DataSource)dataSource), (DBUtil.RunnableWithConnection)new DBUtil.RunnableWithConnection<Object>(){

            public Object run(Connection connection) throws SQLException {
                DBUtil.execute((Connection)connection, (CharSequence)"SHUTDOWN");
                return null;
            }
        });
    }
}

