/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ComparisonIndex {
    private final Multimap<Object, ReferenceChange> refChangeIndex;
    private final Comparison comparison;

    private ComparisonIndex(Comparison comparison) {
        this.comparison = comparison;
        this.refChangeIndex = LinkedHashMultimap.create();
        this.index();
    }

    public static ComparisonIndex index(Comparison comparison, Monitor monitor) {
        monitor.subTask("Indexing differences...");
        ComparisonIndex index = new ComparisonIndex(comparison);
        monitor.subTask("Indexing differences... Done.");
        return index;
    }

    private void index() {
        for (Diff diff : this.comparison.getDifferences()) {
            if (!(diff instanceof ReferenceChange)) continue;
            EObject value = ((ReferenceChange)diff).getValue();
            Match match = this.comparison.getMatch(value);
            if (match != null) {
                this.refChangeIndex.put((Object)match, (Object)((ReferenceChange)diff));
                continue;
            }
            this.refChangeIndex.put((Object)EcoreUtil.getURI((EObject)value), (Object)((ReferenceChange)diff));
        }
    }

    public Collection<ReferenceChange> getReferenceChangesByValue(EObject value) {
        Match match = this.comparison.getMatch(value);
        if (this.refChangeIndex.containsKey((Object)match)) {
            return this.refChangeIndex.get((Object)match);
        }
        return this.getReferenceChangesByValueURI(EcoreUtil.getURI((EObject)value));
    }

    public Collection<ReferenceChange> getReferenceChangesByValueMatch(Match valueMatch) {
        if (this.refChangeIndex.containsKey((Object)valueMatch)) {
            return this.refChangeIndex.get((Object)valueMatch);
        }
        return Collections.emptyList();
    }

    public Collection<ReferenceChange> getReferenceChangesByValueURI(URI valueURI) {
        if (this.refChangeIndex.containsKey((Object)valueURI)) {
            return this.refChangeIndex.get((Object)valueURI);
        }
        return Collections.emptyList();
    }
}

