/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ssh.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ssh.core.ISshConnection;
import org.eclipse.dltk.ssh.internal.core.SshConnection;

public class SshConnectionManager {
    private static Map<String, SshConnection> connections = new HashMap<String, SshConnection>();

    public static synchronized ISshConnection getConnection(String user_host) {
        if (connections.containsKey(user_host)) {
            return connections.get(user_host);
        }
        int indexOf = user_host.indexOf("@");
        String userName = user_host.substring(0, indexOf);
        String hostName = user_host.substring(indexOf + 1);
        int portIndexOf = hostName.indexOf(":");
        int port = 22;
        if (portIndexOf != -1) {
            port = Integer.parseInt(hostName.substring(portIndexOf + 1));
            hostName = hostName.substring(0, portIndexOf);
        }
        SshConnection connection = new SshConnection(userName, hostName, port);
        connections.put(user_host, connection);
        return connection;
    }

    public static void disconnectAll() {
        SshConnectionManager.disconnectAll(false);
    }

    public static synchronized void disconnectAll(boolean destroyAll) {
        Collection<SshConnection> values = connections.values();
        for (ISshConnection iSshConnection : values) {
            iSshConnection.disconnect();
            iSshConnection.setDisabled(-129542144);
        }
        if (destroyAll) {
            connections.clear();
        }
    }
}

