/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMNumber;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMReal
extends ASMNumber {
    private double s;

    public ASMReal(double s) {
        super(myType);
        this.s = s;
    }

    public String toString() {
        return "" + this.s;
    }

    public double getSymbol() {
        return this.s;
    }

    @Override
    public double asDouble() {
        return this.s;
    }

    public boolean equals(Object o) {
        return o instanceof ASMReal && ((ASMReal)o).s == this.s;
    }

    public static ASMReal operatorMinus(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMReal(self.s - o.asDouble());
    }

    public static ASMReal operatorPlus(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMReal(self.s + o.asDouble());
    }

    public static ASMReal operatorMul(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMReal(self.s * o.asDouble());
    }

    public static ASMReal operatorDiv(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMReal(self.s / o.asDouble());
    }

    public static ASMBoolean operatorEQ(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMBoolean(self.s == o.asDouble());
    }

    public static ASMBoolean operatorNE(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMBoolean(self.s != o.asDouble());
    }

    public static ASMBoolean operatorLT(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMBoolean(self.s < o.asDouble());
    }

    public static ASMBoolean operatorLE(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMBoolean(self.s <= o.asDouble());
    }

    public static ASMBoolean operatorGT(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMBoolean(self.s > o.asDouble());
    }

    public static ASMBoolean operatorGE(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMBoolean(self.s >= o.asDouble());
    }

    public static ASMString toString(StackFrame frame, ASMReal self) {
        return new ASMString("" + self.s);
    }

    public static ASMReal abs(StackFrame frame, ASMReal self) {
        return new ASMReal(Math.abs(self.s));
    }

    public static ASMInteger round(StackFrame frame, ASMReal self) {
        return new ASMInteger((int)Math.round(self.s));
    }

    public static ASMInteger floor(StackFrame frame, ASMReal self) {
        return new ASMInteger((int)Math.floor(self.s));
    }

    public static ASMReal max(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMReal(Math.max(self.s, o.asDouble()));
    }

    public static ASMReal min(StackFrame frame, ASMReal self, ASMNumber o) {
        return new ASMReal(Math.min(self.s, o.asDouble()));
    }

    public static ASMReal acos(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.acos(self.asDouble()));
    }

    public static ASMReal asin(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.asin(self.asDouble()));
    }

    public static ASMReal atan(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.atan(self.asDouble()));
    }

    public static ASMReal cos(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.cos(self.asDouble()));
    }

    public static ASMReal sin(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.sin(self.asDouble()));
    }

    public static ASMReal tan(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.tan(self.asDouble()));
    }

    public static ASMReal toDegrees(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.toDegrees(self.asDouble()));
    }

    public static ASMReal toRadians(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.toRadians(self.asDouble()));
    }

    public static ASMReal exp(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.exp(self.asDouble()));
    }

    public static ASMReal log(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.log(self.asDouble()));
    }

    public static ASMReal sqrt(StackFrame frame, ASMNumber self) {
        return new ASMReal(Math.sqrt(self.asDouble()));
    }
}

