/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.dom.VarConflictVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class BreakLoopCleanUpCore
extends AbstractMultiFix {
    public BreakLoopCleanUpCore() {
        this(Collections.emptyMap());
    }

    public BreakLoopCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.break_loop");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.break_loop")) {
            return new String[]{MultiFixMessages.BreakLoopCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("boolean isFound = false;\n");
        bld.append("for (int i = 0; i < number; i++) {\n");
        bld.append("    if (i == 42) {\n");
        bld.append("        isFound = true;\n");
        if (this.isEnabled("cleanup.break_loop")) {
            bld.append("        break;\n");
        }
        bld.append("    }\n");
        bld.append("}\n");
        if (!this.isEnabled("cleanup.break_loop")) {
            bld.append("\n");
        }
        return bld.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.break_loop")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(ForStatement node) {
                HashSet<SimpleName> vars = new HashSet<SimpleName>();
                List initializers = node.initializers();
                for (Expression initializer : initializers) {
                    vars.addAll(ASTNodes.getLocalVariableIdentifiers((ASTNode)initializer, true));
                }
                if (node.getExpression() == null || this.hasDisturbingEffect((ASTNode)node.getExpression(), vars) || node.updaters().isEmpty()) {
                    return true;
                }
                List updaters = node.updaters();
                for (Expression updater : updaters) {
                    if (!this.hasDisturbingEffect((ASTNode)updater, vars)) continue;
                    return true;
                }
                return this.visitLoopBody(node.getBody(), vars);
            }

            private boolean hasDisturbingEffect(ASTNode node, Set<SimpleName> allowedVars) {
                DisturbingEffectVisitor variableUseVisitor = new DisturbingEffectVisitor(allowedVars);
                variableUseVisitor.traverseNodeInterruptibly(node);
                return variableUseVisitor.hasDisturbingEffect();
            }

            public boolean visit(EnhancedForStatement node) {
                if (ASTNodes.isArray(node.getExpression())) {
                    HashSet<SimpleName> vars = new HashSet<SimpleName>();
                    vars.add(node.getParameter().getName());
                    return this.visitLoopBody(node.getBody(), vars);
                }
                return true;
            }

            private boolean visitLoopBody(Statement body, Set<SimpleName> allowedVars) {
                List<Statement> assignments;
                List<Statement> statements = ASTNodes.asList(body);
                if (statements == null || statements.isEmpty()) {
                    return true;
                }
                int i = 0;
                while (i < statements.size() - 1) {
                    Statement statement = statements.get(i);
                    allowedVars.addAll(ASTNodes.getLocalVariableIdentifiers((ASTNode)statement, true));
                    if (this.hasDisturbingEffect((ASTNode)statement, allowedVars)) {
                        return true;
                    }
                    ++i;
                }
                IfStatement ifStatement = ASTNodes.as(statements.get(statements.size() - 1), IfStatement.class);
                if (ifStatement != null && ifStatement.getElseStatement() == null && !this.hasDisturbingEffect((ASTNode)ifStatement.getExpression(), allowedVars) && this.areAssignmentsValid(allowedVars, assignments = ASTNodes.asList(ifStatement.getThenStatement()))) {
                    rewriteOperations.add(new BreakLoopOperation(ifStatement));
                    return false;
                }
                return true;
            }

            private boolean areAssignmentsValid(Set<SimpleName> allowedVars, List<Statement> assignments) {
                if (assignments.isEmpty()) {
                    return false;
                }
                for (Statement statement : assignments) {
                    VariableDeclarationStatement variableDeclaration = ASTNodes.as(statement, VariableDeclarationStatement.class);
                    Assignment assignment = ASTNodes.asExpression(statement, Assignment.class);
                    if (variableDeclaration != null) {
                        for (Object obj : variableDeclaration.fragments()) {
                            VariableDeclarationFragment fragment = (VariableDeclarationFragment)obj;
                            if (ASTNodes.isHardCoded(fragment.getInitializer())) continue;
                            return false;
                        }
                        continue;
                    }
                    if (assignment != null && ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && ASTNodes.isHardCoded(assignment.getRightHandSide()) && ASTNodes.isPassive((ASTNode)assignment.getLeftHandSide())) {
                        VarConflictVisitor varOccurrenceVisitor = new VarConflictVisitor(allowedVars, true);
                        varOccurrenceVisitor.traverseNodeInterruptibly((ASTNode)assignment.getLeftHandSide());
                        if (!varOccurrenceVisitor.isVarConflicting()) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }

            final class DisturbingEffectVisitor
            extends InterruptibleVisitor {
                private final Set<SimpleName> localVariableNames;
                private boolean hasDisturbingEffect;

                private DisturbingEffectVisitor(Set<SimpleName> localVariableNames) {
                    this.localVariableNames = localVariableNames;
                }

                private boolean hasDisturbingEffect() {
                    return this.hasDisturbingEffect;
                }

                public boolean visit(Assignment node) {
                    if (!ASTNodes.hasOperator(node, Assignment.Operator.ASSIGN, new Assignment.Operator[0])) {
                        this.hasDisturbingEffect = true;
                        return this.interruptVisit();
                    }
                    return this.visitVar(node.getLeftHandSide());
                }

                private boolean visitVar(Expression modifiedVar) {
                    if (!(modifiedVar instanceof SimpleName)) {
                        this.hasDisturbingEffect = true;
                        return this.interruptVisit();
                    }
                    boolean isFound = false;
                    for (SimpleName localVariableName : this.localVariableNames) {
                        if (!ASTNodes.isSameVariable((ASTNode)localVariableName, (ASTNode)modifiedVar)) continue;
                        isFound = true;
                        break;
                    }
                    if (!isFound) {
                        this.hasDisturbingEffect = true;
                        return this.interruptVisit();
                    }
                    return true;
                }

                public boolean visit(PrefixExpression node) {
                    if (ASTNodes.hasOperator(node, PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT)) {
                        return this.visitVar(node.getOperand());
                    }
                    return true;
                }

                public boolean visit(PostfixExpression node) {
                    return this.visitVar(node.getOperand());
                }

                public boolean visit(InfixExpression node) {
                    if (ASTNodes.hasOperator(node, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0]) && ASTNodes.hasType((Expression)node, String.class.getCanonicalName()) && (this.mayCallImplicitToString(node.getLeftOperand()) || this.mayCallImplicitToString(node.getRightOperand()) || this.mayCallImplicitToString(node.extendedOperands()))) {
                        this.hasDisturbingEffect = true;
                        return this.interruptVisit();
                    }
                    return true;
                }

                private boolean mayCallImplicitToString(List<Expression> extendedOperands) {
                    if (extendedOperands != null) {
                        for (Expression expression : extendedOperands) {
                            if (!this.mayCallImplicitToString(expression)) continue;
                            return true;
                        }
                    }
                    return false;
                }

                private boolean mayCallImplicitToString(Expression expression) {
                    return !ASTNodes.hasType(expression, String.class.getCanonicalName(), Boolean.TYPE.getSimpleName(), Short.TYPE.getSimpleName(), Integer.TYPE.getSimpleName(), Long.TYPE.getSimpleName(), Float.TYPE.getSimpleName(), Double.TYPE.getSimpleName(), Short.class.getCanonicalName(), Boolean.class.getCanonicalName(), Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName()) && !(expression instanceof PrefixExpression) && !(expression instanceof InfixExpression) && !(expression instanceof PostfixExpression);
                }

                public boolean visit(SuperMethodInvocation node) {
                    this.hasDisturbingEffect = true;
                    return this.interruptVisit();
                }

                public boolean visit(MethodInvocation node) {
                    this.hasDisturbingEffect = true;
                    return this.interruptVisit();
                }

                public boolean visit(ClassInstanceCreation node) {
                    this.hasDisturbingEffect = true;
                    return this.interruptVisit();
                }

                public boolean visit(ThrowStatement node) {
                    this.hasDisturbingEffect = true;
                    return this.interruptVisit();
                }

                public boolean visit(ReturnStatement node) {
                    this.hasDisturbingEffect = true;
                    return this.interruptVisit();
                }

                public boolean visit(BreakStatement node) {
                    if (node.getLabel() != null) {
                        this.hasDisturbingEffect = true;
                        return this.interruptVisit();
                    }
                    return true;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.BreakLoopCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class BreakLoopOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final IfStatement ifStatement;

        public BreakLoopOperation(IfStatement ifStatement) {
            this.ifStatement = ifStatement;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.BreakLoopCleanUp_description, cuRewrite);
            if (this.ifStatement.getThenStatement() instanceof Block) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.ifStatement.getThenStatement(), Block.STATEMENTS_PROPERTY);
                listRewrite.insertLast((ASTNode)ast.newBreakStatement(), group);
            } else {
                Block newBlock = ast.newBlock();
                newBlock.statements().add(ASTNodes.createMoveTarget(rewrite, this.ifStatement.getThenStatement()));
                newBlock.statements().add(ast.newBreakStatement());
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.ifStatement.getThenStatement(), (ASTNode)newBlock, group);
            }
        }
    }
}

