/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.caching.ArchiveContentCacheProvider;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersBlock;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.AddTclInterpreterDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TclInterpretersBlock
extends InterpretersBlock {
    private Button fetchInterpreterInformation;

    protected AddScriptInterpreterDialog createInterpreterDialog(IInterpreterInstall standin) {
        AddTclInterpreterDialog dialog = new AddTclInterpreterDialog((IAddInterpreterDialogRequestor)this, this.getShell(), ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentNature()), standin);
        return dialog;
    }

    protected String getCurrentNature() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public void createControl(Composite ancestor) {
        super.createControl(ancestor);
        this.fetchInterpreterInformation = this.createPushButton(this.buttons, "Fetch information");
        this.fetchInterpreterInformation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = TclInterpretersBlock.this.fInterpreterList.getStructuredSelection();
                IInterpreterInstall install = (IInterpreterInstall)selection.getFirstElement();
                TclInterpretersBlock.this.fetchInterpreterInformation(install);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableButtons();
    }

    protected void enableButtons() {
        super.enableButtons();
        if (this.fetchInterpreterInformation != null) {
            IStructuredSelection selection = this.fInterpreterList.getStructuredSelection();
            int selectionCount = selection.size();
            if (selectionCount == 1) {
                this.fetchInterpreterInformation.setEnabled(true);
            } else {
                this.fetchInterpreterInformation.setEnabled(false);
            }
        }
    }

    private void fetchInterpreterInformation(IInterpreterInstall install) {
        block2: {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fetchInterpreterInformation.getShell());
            try {
                dialog.run(true, true, monitor -> {
                    IContentCache cache = ModelManager.getModelManager().getCoreCache();
                    monitor.beginTask("Fetching interpreter information", 100);
                    List list = null;
                    try {
                        TclPackagesManager.markInterprterAsNotFetched((IInterpreterInstall)install);
                        list = TclPackagesManager.getPackageInfos((IInterpreterInstall)install);
                    }
                    catch (Exception e1) {
                        list = TclPackagesManager.getPackageInfos((IInterpreterInstall)install);
                    }
                    monitor.worked(20);
                    SubProgressMonitor smon0 = new SubProgressMonitor(monitor, 40);
                    int s = 0;
                    int lsize = list.size();
                    smon0.beginTask("Fetch package information", lsize / 50);
                    while (s < lsize) {
                        int part;
                        block13: {
                            part = 50;
                            if (lsize - s < part) {
                                part = lsize - s;
                            }
                            if (smon0.isCanceled()) break;
                            smon0.subTask("Processing packages info (" + (lsize - s) + " left)");
                            HashSet<String> pkgs = new HashSet<String>();
                            int i2 = s;
                            while (i2 < s + part) {
                                pkgs.add(((TclPackageInfo)list.get(i2)).getName());
                                ++i2;
                            }
                            try {
                                List i2 = TclPackagesManager.getPackageInfos((IInterpreterInstall)install, pkgs, (boolean)true);
                            }
                            catch (Exception e2) {
                                if (!DLTKCore.DEBUG) break block13;
                                e2.printStackTrace();
                            }
                        }
                        s += part;
                        smon0.worked(1);
                    }
                    smon0.done();
                    SubProgressMonitor smon = new SubProgressMonitor(monitor, 40);
                    IEnvironment env = install.getEnvironment();
                    smon.beginTask("Processing packages", lsize);
                    int index = 1;
                    for (TclPackageInfo tclPackageInfo : list) {
                        boolean processed;
                        block14: {
                            smon.subTask("Processing package:" + tclPackageInfo.getName() + " (" + (lsize - index) + " left)");
                            ++index;
                            if (smon.isCanceled()) break;
                            processed = false;
                            try {
                                TclPackageInfo info = TclPackagesManager.getPackageInfo((IInterpreterInstall)install, (String)tclPackageInfo.getName(), (boolean)true);
                                if (info != null) {
                                    EList sources = info.getSources();
                                    HashSet<IPath> parents = new HashSet<IPath>();
                                    for (String source : sources) {
                                        Path path1 = new Path(source);
                                        IPath parent = path1.removeLastSegments(1);
                                        parents.add(parent);
                                    }
                                    for (IPath path2 : parents) {
                                        IFileHandle file = env.getFile(path2);
                                        if (!file.exists()) continue;
                                        ArchiveContentCacheProvider.processFolderIndexes((IFileHandle)file, (IContentCache)cache, (IProgressMonitor)smon);
                                        processed = true;
                                    }
                                }
                            }
                            catch (Exception e3) {
                                if (!DLTKCore.DEBUG) break block14;
                                e3.printStackTrace();
                            }
                        }
                        if (processed) continue;
                        smon.worked(1);
                    }
                    smon.done();
                    monitor.done();
                });
            }
            catch (Exception e1) {
                if (!DLTKCore.DEBUG) break block2;
                e1.printStackTrace();
            }
        }
    }
}

