/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilderWrapper;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsFactory;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTTrigger;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.updater.ProceduralObjectSourceUpdater;

public class TriggerSourceUpdater
extends ProceduralObjectSourceUpdater
implements IGenericDdlConstants {
    protected Trigger _trigger = null;

    public TriggerSourceUpdater(Trigger trigger, DatabaseDefinition definition) {
        super((SQLObject)trigger, definition);
        this._trigger = trigger;
    }

    public String getBody() {
        return SybaseDdlBuilderWrapper.getInstance().getTriggerBody(this._trigger);
    }

    public void setBody(String body) {
        this._trigger.getActionStatement().clear();
        SQLStatementDefault stmt = SQLStatementsFactory.eINSTANCE.createSQLStatementDefault();
        stmt.setSQL(body);
        this._trigger.getActionStatement().add((Object)stmt);
    }

    public boolean updateEvents() {
        String newEvents = this.getTriggerEvents();
        if (newEvents == null || newEvents.trim().equals("")) {
            return false;
        }
        String body = this.getBody();
        ParsingResult result = this._parser.parse(body, this._parserParameters);
        IASTTrigger node = this.getASTTrigger(result);
        if (node != null) {
            Node eventsNode = node.getTriggerEvents();
            int start = this._parser.getStartIndex(eventsNode.getFirstToken());
            int end = this._parser.getStartIndex(eventsNode.getLastToken().next);
            body = String.valueOf(body.substring(0, start)) + newEvents + body.substring(end);
            this.setBody(body);
            return true;
        }
        return false;
    }

    protected String getTriggerEvents() {
        return SybaseDdlBuilderWrapper.getInstance().getTriggerEvents(this._trigger);
    }

    protected IASTTrigger getASTTrigger(ParsingResult result) {
        IASTStart root = result.getRootNode();
        int i = 0;
        while (i < root.jjtGetNumChildren()) {
            Node node = root.jjtGetChild(i);
            if (node instanceof IASTTrigger) {
                return (IASTTrigger)node;
            }
            ++i;
        }
        return null;
    }
}

