/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.ui.RSEAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardDescriptor;
import org.eclipse.ui.IViewPart;
import org.osgi.framework.Bundle;

public class RSESystemTypeAdapter
extends RSEAdapter {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor img = this.getImage(object, "icon");
        if (img == null) {
            img = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionIcon");
        }
        return img;
    }

    public ImageDescriptor getLiveImageDescriptor(Object object) {
        ImageDescriptor img = this.getImage(object, "iconLive");
        if (img == null) {
            img = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionliveIcon");
        }
        return img;
    }

    private ImageDescriptor getImage(Object object, String propertyKey) {
        if (object != null && object instanceof IRSESystemType) {
            IRSESystemType sysType = (IRSESystemType)object;
            String property = sysType.getProperty(propertyKey);
            if (property != null) {
                return RSESystemTypeAdapter.getImage(property, sysType.getDefiningBundle());
            }
            return null;
        }
        return null;
    }

    public static ImageDescriptor getImage(String value, Bundle definingBundle) {
        URL url = RSESystemTypeAdapter.getUrl(value, definingBundle);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    public static URL getUrl(String value, Bundle definingBundle) {
        URL result;
        block3: {
            result = null;
            try {
                if (value != null) {
                    result = new URL(value);
                }
            }
            catch (MalformedURLException e) {
                if (definingBundle == null) break block3;
                Path path = new Path(value);
                result = FileLocator.find((Bundle)definingBundle, (IPath)path, null);
            }
        }
        return result;
    }

    public String getLabel(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            return ((IRSESystemType)object).getLabel();
        }
        return super.getLabel(object);
    }

    public String getDescription(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            return ((IRSESystemType)object).getDescription();
        }
        return super.getDescription(object);
    }

    public boolean isEnableOffline(Object object) {
        if (object instanceof IRSESystemType) {
            String property = ((IRSESystemType)object).getProperty("enableOffline");
            if (property != null) {
                return Boolean.valueOf(property);
            }
            return false;
        }
        return false;
    }

    public final boolean isEnabled(Object object) {
        IRSESystemType systemType = RSESystemTypeAdapter.getSystemType(object);
        if (systemType != null) {
            return systemType.isEnabled();
        }
        return false;
    }

    public void setIsEnabled(Object object, boolean isEnabled) {
        IRSESystemType systemType = RSESystemTypeAdapter.getSystemType(object);
        if (systemType != null) {
            RSEPreferencesManager.setIsSystemTypeEnabled((IRSESystemType)systemType, (boolean)isEnabled);
        }
    }

    public String getDefaultUserId(Object object) {
        String result = null;
        IRSESystemType systemType = RSESystemTypeAdapter.getSystemType(object);
        if (systemType != null) {
            result = RSEPreferencesManager.getDefaultUserId((IRSESystemType)systemType);
        }
        return result;
    }

    public void setDefaultUserId(Object object, String defaultUserId) {
        IRSESystemType systemType = RSESystemTypeAdapter.getSystemType(object);
        if (systemType != null) {
            RSEPreferencesManager.setDefaultUserId((IRSESystemType)systemType, (String)defaultUserId);
        }
    }

    private static IRSESystemType getSystemType(Object systemTypeCandidate) {
        IRSESystemType result = null;
        if (systemTypeCandidate instanceof IRSESystemType) {
            result = (IRSESystemType)systemTypeCandidate;
        }
        return result;
    }

    public void addCustomToolbarGroups(IViewPart view) {
    }

    public void addCustomMenuGroups(IMenuManager menu) {
    }

    public boolean acceptWizardDescriptor(String wizardConfigurationElementName, IRSEWizardDescriptor descriptor) {
        if (!($assertionsDisabled || wizardConfigurationElementName != null && descriptor != null)) {
            throw new AssertionError();
        }
        return "org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard".equals(descriptor.getId());
    }
}

