/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclType;

public class OclParametrizedType
extends OclType {
    private OclType elementType;

    public OclParametrizedType(String name, Object elementType) {
        this.setName(name);
        this.setElementType(elementType);
    }

    public OclParametrizedType() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof OclParametrizedType) {
            return ((OclParametrizedType)obj).getName().equals(this.getName()) && ((OclParametrizedType)obj).getElementType().equals(this.elementType);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.elementType + ")";
    }

    public OclType getElementType() {
        return this.elementType;
    }

    public void setElementType(Object elementType) {
        if (elementType instanceof OclType) {
            this.elementType = (OclType)elementType;
        } else {
            OclType oclType = OclParametrizedType.getOclTypeFromObject(elementType);
            if (oclType != null) {
                this.elementType = OclParametrizedType.getOclTypeFromObject(elementType);
            } else {
                throw new VMException(null, String.valueOf(Messages.getString("OclParametrizedType.UNDEFINED_PARAM_TYPE")) + elementType);
            }
        }
    }

    @Override
    public boolean conformsTo(OclType other) {
        boolean ret = this.equals(other);
        if (!ret && other instanceof OclParametrizedType) {
            OclParametrizedType aopt = (OclParametrizedType)other;
            ret = "Collection".equals(aopt.getName()) ? this.elementType.conformsTo(aopt.getElementType()) : aopt.getName().equals(this.getName()) && this.elementType.conformsTo(aopt.getElementType());
        }
        return ret;
    }
}

