/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.common;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.jee.JEEPlugin;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class AbstractMergedModelProvider<T>
implements IModelProvider {
    protected IModelProvider ddProvider;
    protected IModelProvider annotationModelProvider;
    private Collection<IModelProviderListener> listeners;
    protected IProject project;
    private AnnotationModelListener annotationModelListener;
    private XmlModelListener xmlModelListener;
    protected T mergedModel;
    protected long cache_last_change;

    private boolean disposeIfNeeded(IModelProviderEvent event) {
        if (this.isDisposed() || this.mergedModel == null) {
            return true;
        }
        if (this.shouldDispose(event)) {
            this.dispose();
            this.notifyListeners(event);
            return true;
        }
        return false;
    }

    public AbstractMergedModelProvider(IProject project) {
        this.project = project;
    }

    public void addListener(IModelProviderListener listener) {
        this.getListeners().add(listener);
    }

    public Object getModelObject() {
        return this.getMergedModel();
    }

    public void modify(Runnable runnable, IPath modelPath) {
    }

    public void removeListener(IModelProviderListener listener) {
        this.getListeners().remove(listener);
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        if (this.ddProvider == null) {
            this.getModelObject();
        }
        return this.ddProvider.validateEdit(modelPath, context);
    }

    protected abstract void annotationModelChanged(IModelProviderEvent var1);

    protected abstract void xmlModelChanged(IModelProviderEvent var1);

    protected abstract T merge(T var1, T var2);

    protected abstract IModelProvider loadAnnotationModel(T var1) throws CoreException;

    protected abstract IModelProvider loadDeploymentDescriptorModel() throws CoreException;

    public Collection<IModelProviderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IModelProviderListener>();
        }
        return this.listeners;
    }

    protected T getMergedModel() {
        try {
            if (this.mergedModel == null || this.hasToReloadModel()) {
                this.mergedModel = this.loadModel();
            }
        }
        catch (CoreException e) {
            JEEPlugin.getDefault().getLog().log(e.getStatus());
            return null;
        }
        return this.mergedModel;
    }

    private boolean hasToReloadModel() {
        long lastModificationTimeOfDDFile = this.getLastModificationTimeOfDDFile();
        return lastModificationTimeOfDDFile == -1L ? false : lastModificationTimeOfDDFile != this.cache_last_change;
    }

    private long getLastModificationTimeOfDDFile() {
        if (this.ddProvider == null || this.ddProvider.getModelObject() == null || ((EObject)this.ddProvider.getModelObject()).eResource() == null) {
            return -1L;
        }
        return WorkbenchResourceHelper.getFile((Resource)((EObject)this.ddProvider.getModelObject()).eResource()).getLocalTimeStamp();
    }

    protected T loadModel() throws CoreException {
        if (!this.project.isAccessible()) {
            throw new IllegalStateException("The project <" + this.project + "> is not accessible.");
        }
        this.project.getWorkspace().run((IWorkspaceRunnable)new LoadModelsWorkspaceRunnable(), (ISchedulingRule)this.project, 1, (IProgressMonitor)new NullProgressMonitor());
        return this.mergedModel;
    }

    private void loadProviders() throws CoreException {
        if (this.ddProvider == null || this.hasToReloadModel()) {
            if (this.hasToReloadModel()) {
                ((EObject)this.ddProvider.getModelObject()).eResource().unload();
            }
            this.ddProvider = this.loadDeploymentDescriptorModel();
        }
        if (this.ddProvider == null || this.ddProvider.getModelObject() == null) {
            return;
        }
        if (this.annotationModelProvider == null) {
            this.annotationModelProvider = this.loadAnnotationModel(this.ddProvider.getModelObject());
        }
        if (this.annotationModelProvider == null || this.annotationModelProvider.getModelObject() == null) {
            return;
        }
        Object ddModel = this.ddProvider.getModelObject();
        Object annotationModel = this.annotationModelProvider.getModelObject();
        this.mergedModel = this.createNewModelInstance();
        this.initMergedModelResource((EObject)ddModel);
        this.enableInternalNotifications();
        this.merge(ddModel, annotationModel);
    }

    protected abstract T createNewModelInstance();

    protected void initMergedModelResource(EObject ddModel) {
        Resource resourceDD = ddModel.eResource();
        if (this.ddProvider != null) {
            this.cache_last_change = this.getLastModificationTimeOfDDFile();
        }
        Resource resourceMM = ((EObject)this.mergedModel).eResource();
        if (resourceDD != null && resourceMM == null) {
            ResourceImpl resRes = new ResourceImpl(resourceDD.getURI());
            resRes.getContents().add((Object)((EObject)this.mergedModel));
        }
    }

    protected final void enableInternalNotifications() {
        this.xmlModelListener = new XmlModelListener();
        this.ddProvider.addListener((IModelProviderListener)this.xmlModelListener);
        this.annotationModelListener = new AnnotationModelListener();
        this.annotationModelProvider.addListener((IModelProviderListener)this.annotationModelListener);
    }

    protected final void disableInternalNotifications() {
        this.ddProvider.removeListener((IModelProviderListener)this.xmlModelListener);
        this.annotationModelProvider.removeListener((IModelProviderListener)this.annotationModelListener);
    }

    protected void notifyListeners(final IModelProviderEvent event) {
        IModelProviderListener[] backup;
        event.setModel((IModelProvider)this);
        event.setProject(this.project);
        Collection<IModelProviderListener> listeners = this.getListeners();
        IModelProviderListener[] iModelProviderListenerArray = backup = listeners.toArray(new IModelProviderListener[listeners.size()]);
        int n = backup.length;
        int n2 = 0;
        while (n2 < n) {
            final IModelProviderListener listener = iModelProviderListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.modelsChanged(event);
                }
            });
            ++n2;
        }
        backup = null;
    }

    protected boolean shouldDispose(IModelProviderEvent event) {
        return event.getEventCode() == 64;
    }

    public boolean isDisposed() {
        return this.ddProvider == null && this.annotationModelProvider == null;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.disableInternalNotifications();
        this.ddProvider = null;
        this.annotationModelProvider = null;
        this.mergedModel = null;
    }

    private class AnnotationModelListener
    implements IModelProviderListener {
        private AnnotationModelListener() {
        }

        public void modelsChanged(IModelProviderEvent event) {
            if (AbstractMergedModelProvider.this.disposeIfNeeded(event)) {
                return;
            }
            AbstractMergedModelProvider.this.annotationModelChanged(event);
        }
    }

    private class LoadModelsWorkspaceRunnable
    implements IWorkspaceRunnable {
        private LoadModelsWorkspaceRunnable() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            AbstractMergedModelProvider.this.loadProviders();
        }
    }

    private class XmlModelListener
    implements IModelProviderListener {
        private XmlModelListener() {
        }

        public void modelsChanged(IModelProviderEvent event) {
            if (AbstractMergedModelProvider.this.disposeIfNeeded(event)) {
                return;
            }
            AbstractMergedModelProvider.this.xmlModelChanged(event);
            if (AbstractMergedModelProvider.this.ddProvider != null) {
                AbstractMergedModelProvider.this.cache_last_change = AbstractMergedModelProvider.this.getLastModificationTimeOfDDFile();
            }
        }
    }
}

