/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.internal.image;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidParameterException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.AbstractRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ImageRenderedImage
extends AbstractRenderedImage {
    private final RGB TRANSPARENT_COLOR = new RGB(0, 0, 0);

    public ImageRenderedImage(byte[] buff, RenderedImageKey key) {
        super(buff, key);
    }

    @Override
    protected Image renderImage() {
        try {
            ImageLoader loader = new ImageLoader();
            ByteArrayInputStream byteIS = new ByteArrayInputStream(this.getBuffer());
            ImageData[] origImgData = loader.load((InputStream)byteIS);
            if (origImgData == null) {
                throw new InvalidParameterException();
            }
            int origWidth = origImgData[0].width;
            int origHeight = origImgData[0].height;
            int bufferWidth = this.getKey().getWidth() == 0 ? origWidth : this.getKey().getWidth();
            int bufferHeight = this.getKey().getHeight() == 0 ? origHeight : this.getKey().getHeight();
            int newWidth = bufferWidth;
            int newHeight = bufferHeight;
            Display display = DisplayUtils.getDisplay();
            if (this.getKey().shouldMaintainAspectRatio()) {
                double origAspectRatio = (double)origHeight / (double)origWidth;
                if (origAspectRatio > (double)newHeight / (double)newWidth) {
                    newWidth = (int)Math.round((double)newHeight / origAspectRatio);
                } else {
                    newHeight = (int)Math.round((double)newWidth * origAspectRatio);
                }
                double scale = 1.0;
                if (newWidth > bufferWidth) {
                    scale = bufferWidth / newWidth;
                }
                if (newHeight > bufferHeight) {
                    scale = Math.min(scale, (double)bufferHeight / (double)newHeight);
                }
                newWidth = (int)((double)newWidth * scale);
                newHeight = (int)((double)newHeight * scale);
                PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
                ImageData imgData = new ImageData(bufferWidth, bufferHeight, 24, paletteData);
                imgData.transparentPixel = paletteData.getPixel(this.TRANSPARENT_COLOR);
                TwoImageDescriptor desc = new TwoImageDescriptor(imgData, origImgData[0].scaledTo(newWidth, newHeight), bufferWidth, bufferHeight);
                return desc.createImage();
            }
            ImageData scaledImgData = origImgData[0].scaledTo(newWidth, newHeight);
            return new Image((Device)display, scaledImgData);
        }
        catch (Exception e) {
            Trace.throwing((Plugin)Draw2dRenderPlugin.getInstance(), (String)Draw2dRenderDebugOptions.EXCEPTIONS_THROWING, ImageRenderedImage.class, (String)"ImageRenderedImage.renderImage() : couldn't load image from buffer", (Throwable)e);
            return null;
        }
    }

    private static class TwoImageDescriptor
    extends CompositeImageDescriptor {
        private Point size;
        private ImageData bgImgData;
        private ImageData actualImgData;

        public TwoImageDescriptor(ImageData bgImgData, ImageData actualImgData, int bufferWidth, int bufferHeight) {
            this.bgImgData = bgImgData;
            this.actualImgData = actualImgData;
            this.size = new Point(bufferWidth, bufferHeight);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.bgImgData, 0, 0);
            this.drawImage(this.actualImgData, (this.size.x - this.actualImgData.width) / 2, (this.size.y - this.actualImgData.height) / 2);
        }

        protected Point getSize() {
            return this.size;
        }
    }
}

