/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferences;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Activator;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.ToolchainDefinition;
import org.eclipse.embedcdt.managedbuild.cross.riscv.ui.preferences.ToolchainsFieldEditor;
import org.eclipse.embedcdt.ui.LabelFakeFieldEditor;
import org.eclipse.embedcdt.ui.XpackDirectoryNotStrictFieldEditor;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GlobalToolchainsPathsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.globalToolchainsPaths";
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();

    public GlobalToolchainsPathsPreferencesPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.embedcdt.managedbuild.cross.riscv.core"));
        this.setDescription(Messages.GlobalToolchainsPathsPreferencesPage_description);
    }

    public void init(IWorkbench workbench) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.GlobalToolchainsPathsPreferencesPage.init()");
        }
    }

    protected void createFieldEditors() {
        int ix;
        IProject[] projects;
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        TreeMap<ToolchainDefinition, Map> toolchains = new TreeMap<ToolchainDefinition, Map>(Comparator.comparing(org.eclipse.embedcdt.managedbuild.cross.core.ToolchainDefinition::getName));
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IConfiguration[] configs = EclipseUtils.getConfigurationsForProject((IProject)project);
            boolean allConfigsUseSameToolchain = true;
            ToolchainDefinition toolchainInUse = null;
            if (configs != null) {
                IConfiguration[] iConfigurationArray = configs;
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    block31: {
                        IConfiguration config = iConfigurationArray[n4];
                        IToolChain toolchain = config.getToolChain();
                        if (toolchain != null) {
                            IOption optionName;
                            IOption optionId = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id");
                            if (optionId != null) {
                                try {
                                    String toolchainId = optionId.getStringValue();
                                    int ix2 = ToolchainDefinition.findToolchainById((String)toolchainId);
                                    ToolchainDefinition toolchainDefinition = ToolchainDefinition.getToolchain((int)ix2);
                                    if (toolchainInUse == null) {
                                        toolchainInUse = toolchainDefinition;
                                    } else if (!toolchainInUse.equals(toolchainDefinition)) {
                                        allConfigsUseSameToolchain = false;
                                    }
                                    Map projectMap = toolchains.computeIfAbsent(toolchainDefinition, x -> new TreeMap());
                                    Set buildConfigsSet = projectMap.computeIfAbsent(project.getName(), x -> new TreeSet());
                                    buildConfigsSet.add(config.getName());
                                    break block31;
                                }
                                catch (BuildException toolchainId) {
                                }
                                catch (IndexOutOfBoundsException toolchainId) {
                                    // empty catch block
                                }
                            }
                            if ((optionName = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name")) != null) {
                                try {
                                    String toolchainName = optionName.getStringValue();
                                    int ix3 = ToolchainDefinition.findToolchainByName((String)toolchainName);
                                    ToolchainDefinition toolchainDefinition = ToolchainDefinition.getToolchain((int)ix3);
                                    if (toolchainInUse == null) {
                                        toolchainInUse = toolchainDefinition;
                                    } else if (!toolchainInUse.equals(toolchainDefinition)) {
                                        allConfigsUseSameToolchain = false;
                                    }
                                    Map projectMap = toolchains.computeIfAbsent(toolchainDefinition, x -> new TreeMap());
                                    Set buildConfigsSet = projectMap.computeIfAbsent(project.getName(), x -> new TreeSet());
                                    buildConfigsSet.add(config.getName());
                                }
                                catch (BuildException toolchainName) {
                                }
                                catch (IndexOutOfBoundsException toolchainName) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++n4;
                }
            }
            if (allConfigsUseSameToolchain && toolchainInUse != null) {
                Set set = (Set)((Map)toolchains.get(toolchainInUse)).get(project.getName());
                set.clear();
            }
            ++n2;
        }
        if (toolchains.isEmpty()) {
            try {
                String toolchainId = this.fPersistentPreferences.getToolchainId();
                ix = ToolchainDefinition.findToolchainById((String)toolchainId);
                toolchains.computeIfAbsent(ToolchainDefinition.getToolchain((int)ix), x -> Map.of());
            }
            catch (IndexOutOfBoundsException toolchainId) {
                // empty catch block
            }
        }
        if (toolchains.isEmpty()) {
            try {
                String toolchainName = this.fPersistentPreferences.getToolchainName();
                ix = ToolchainDefinition.findToolchainByName((String)toolchainName);
                toolchains.computeIfAbsent(ToolchainDefinition.getToolchain((int)ix), x -> Map.of());
            }
            catch (IndexOutOfBoundsException toolchainName) {
                // empty catch block
            }
        }
        if (toolchains.isEmpty()) {
            int ix4 = ToolchainDefinition.getDefault();
            toolchains.computeIfAbsent(ToolchainDefinition.getToolchain((int)ix4), x -> Map.of());
        }
        Group group = new Group(parent, 0);
        group.setText(Messages.GlobalToolchainsPathsPreferencesPage_ToolchainPathGroup_label);
        GridLayout groupLayout = new GridLayout(4, false);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        boolean first = true;
        for (Map.Entry entry : toolchains.entrySet()) {
            if (first) {
                first = false;
            } else {
                Label verticalSpacer = new Label((Composite)group, 0);
                GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
                verticalSpacer.setLayoutData((Object)layoutData);
                verticalSpacer.setText("");
            }
            ToolchainDefinition toolchain = (ToolchainDefinition)entry.getKey();
            Map projectToConfigsMap = (Map)entry.getValue();
            Label message = new Label((Composite)group, 64);
            GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
            message.setLayoutData((Object)layoutData);
            if (projectToConfigsMap.isEmpty()) {
                message.setText(Messages.GlobalToolchainsPathsPreferencesPage_ToolchainMessageDefault_label);
            } else {
                String collected = projectToConfigsMap.entrySet().stream().map(e -> {
                    String projectName = (String)e.getKey();
                    Set configNames = (Set)e.getValue();
                    if (configNames.isEmpty()) {
                        return projectName;
                    }
                    return String.valueOf(projectName) + " (" + String.join((CharSequence)", ", configNames) + ")";
                }).collect(Collectors.joining(", "));
                message.setText(NLS.bind((String)Messages.GlobalToolchainsPathsPreferencesPage_ToolchainMessageWithProjects_label, (Object)collected));
            }
            PixelConverter pixelConverter = new PixelConverter((Control)message);
            layoutData.widthHint = pixelConverter.convertWidthInCharsToPixels(Math.min(message.getText().length(), 100));
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchain.getFullName(), Messages.ToolsPaths_ToolchainName_label, (Composite)group);
            labelField.fillIntoGrid((Composite)group, 4);
            this.addField((FieldEditor)labelField);
            boolean isStrict = this.fDefaultPreferences.getBoolean("workspace.toolchain.path.strict", true);
            String[] xpackNames = this.fDefaultPreferences.getToolchainXpackNames(toolchain.getId(), toolchain.getName());
            String key = PersistentPreferences.getToolchainKey((String)toolchain.getId(), (String)toolchain.getName());
            XpackDirectoryNotStrictFieldEditor toolchainPathField = new XpackDirectoryNotStrictFieldEditor(xpackNames, key, Messages.ToolchainPaths_label, (Composite)group, isStrict);
            toolchainPathField.fillIntoGrid((Composite)group, 4);
            this.addField((FieldEditor)toolchainPathField);
        }
        Label label = new Label((Composite)group, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        label.setLayoutData((Object)layoutData);
        label.setText("");
        Label macOSMessage = new Label((Composite)group, 0);
        layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        macOSMessage.setLayoutData((Object)layoutData);
        macOSMessage.setText(Messages.SetCrossCommandWizardPage_text);
        group.setLayout((Layout)groupLayout);
        Group group1 = new Group(parent, 0);
        group1.setText(Messages.GlobalToolchainsPathsPreferencesPage_ToolchainDefaultGroup_label);
        GridLayout group1Layout = new GridLayout(2, false);
        group1.setLayout((Layout)group1Layout);
        group1.setLayoutData((Object)new GridData(768));
        ToolchainsFieldEditor toolchainNameField = new ToolchainsFieldEditor("toolchain.id", Messages.ToolchainName_label, (Composite)group1);
        toolchainNameField.fillIntoGrid((Composite)group1, 2);
        ((GridData)group1.getChildren()[1].getLayoutData()).grabExcessHorizontalSpace = true;
        this.addField((FieldEditor)toolchainNameField);
        group1.setLayout((Layout)group1Layout);
    }

    protected void adjustGridLayout() {
    }
}

