/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.stream;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.test.common.stream.EntryPipeline;

public interface MapStream<K, V>
extends BaseStream<Map.Entry<K, V>, MapStream<K, V>> {
    public static <K, V> MapStream<K, V> of(Map<? extends K, ? extends V> map) {
        return MapStream.of(map.entrySet());
    }

    public static <K, V> MapStream<K, V> ofNullable(Map<? extends K, ? extends V> map) {
        return map != null ? MapStream.of(map) : MapStream.empty();
    }

    public static <K, V> MapStream<K, V> of(Collection<? extends Map.Entry<? extends K, ? extends V>> collection) {
        return MapStream.of(collection.stream());
    }

    public static <K, V> MapStream<K, V> ofNullable(Collection<? extends Map.Entry<? extends K, ? extends V>> collection) {
        return collection != null ? MapStream.of(collection) : MapStream.empty();
    }

    public static <K, V> MapStream<K, V> of(Stream<? extends Map.Entry<? extends K, ? extends V>> stream) {
        return new EntryPipeline(stream);
    }

    public static <K, V> MapStream<K, V> ofNullable(Stream<? extends Map.Entry<? extends K, ? extends V>> stream) {
        return stream != null ? MapStream.of(stream) : MapStream.empty();
    }

    public static <K, V> MapStream<K, V> concat(MapStream<? extends K, ? extends V> a, MapStream<? extends K, ? extends V> b) {
        return MapStream.of(Stream.concat(a.entries(), b.entries()));
    }

    public static <K, V> MapStream<K, V> empty() {
        return MapStream.of(Stream.empty());
    }

    public static <K, V> MapStream<K, V> of(K k1, V v1) {
        return MapStream.of(Stream.of(MapStream.entry(k1, v1)));
    }

    public static <K, V> MapStream<K, V> of(K k1, V v1, K k2, V v2) {
        return MapStream.ofEntries(MapStream.entry(k1, v1), MapStream.entry(k2, v2));
    }

    public static <K, V> MapStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return MapStream.ofEntries(MapStream.entry(k1, v1), MapStream.entry(k2, v2), MapStream.entry(k3, v3));
    }

    public static <K, V> MapStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return MapStream.ofEntries(MapStream.entry(k1, v1), MapStream.entry(k2, v2), MapStream.entry(k3, v3), MapStream.entry(k4, v4));
    }

    @SafeVarargs
    public static <K, V> MapStream<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        return MapStream.of(Arrays.stream(entries));
    }

    public static <O, K, V> MapStream<K, V> ofEntries(Stream<? extends O> stream, Function<? super O, ? extends Map.Entry<? extends K, ? extends V>> entryMapper) {
        return MapStream.of(stream.map(entryMapper));
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public Stream<Map.Entry<K, V>> entries();

    public Stream<K> keys();

    public Stream<V> values();

    public MapStream<K, V> distinct();

    public MapStream<K, V> filter(BiPredicate<? super K, ? super V> var1);

    public MapStream<K, V> filterKey(Predicate<? super K> var1);

    public MapStream<K, V> filterValue(Predicate<? super V> var1);

    public <R, S> MapStream<R, S> map(BiFunction<? super K, ? super V, ? extends Map.Entry<? extends R, ? extends S>> var1);

    public <R> MapStream<R, V> mapKey(Function<? super K, ? extends R> var1);

    public <S> MapStream<K, S> mapValue(Function<? super V, ? extends S> var1);

    public <O> Stream<O> mapToObj(BiFunction<? super K, ? super V, ? extends O> var1);

    public IntStream mapToInt(ToIntBiFunction<? super K, ? super V> var1);

    public LongStream mapToLong(ToLongBiFunction<? super K, ? super V> var1);

    public DoubleStream mapToDouble(ToDoubleBiFunction<? super K, ? super V> var1);

    public <R, S> MapStream<R, S> flatMap(BiFunction<? super K, ? super V, ? extends MapStream<? extends R, ? extends S>> var1);

    public <R> MapStream<R, V> flatMapKey(Function<? super K, ? extends Stream<? extends R>> var1);

    public <S> MapStream<K, S> flatMapValue(Function<? super V, ? extends Stream<? extends S>> var1);

    public <O> Stream<O> flatMapToObj(BiFunction<? super K, ? super V, ? extends Stream<? extends O>> var1);

    public IntStream flatMapToInt(BiFunction<? super K, ? super V, ? extends IntStream> var1);

    public LongStream flatMapToLong(BiFunction<? super K, ? super V, ? extends LongStream> var1);

    public DoubleStream flatMapToDouble(BiFunction<? super K, ? super V, ? extends DoubleStream> var1);

    public MapStream<K, V> peek(BiConsumer<? super K, ? super V> var1);

    public MapStream<K, V> peekKey(Consumer<? super K> var1);

    public MapStream<K, V> peekValue(Consumer<? super V> var1);

    public MapStream<K, V> sorted();

    public MapStream<K, V> sorted(Comparator<? super Map.Entry<K, V>> var1);

    public MapStream<K, V> sortedByKey();

    public MapStream<K, V> sortedByKey(Comparator<? super K> var1);

    public MapStream<K, V> sortedByValue();

    public MapStream<K, V> sortedByValue(Comparator<? super V> var1);

    public MapStream<K, V> limit(long var1);

    public MapStream<K, V> skip(long var1);

    public long count();

    public void forEach(BiConsumer<? super K, ? super V> var1);

    public void forEachOrdered(BiConsumer<? super K, ? super V> var1);

    public boolean anyMatch(BiPredicate<? super K, ? super V> var1);

    public boolean allMatch(BiPredicate<? super K, ? super V> var1);

    public boolean noneMatch(BiPredicate<? super K, ? super V> var1);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super Map.Entry<? extends K, ? extends V>> var2, BiConsumer<R, R> var3);

    public <R, A> R collect(Collector<? super Map.Entry<? extends K, ? extends V>, A, R> var1);

    public static <K, V> Collector<? super Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<? super Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap(BinaryOperator<V> mergeFunction) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction);
    }

    public static <K, V, M extends Map<K, V>> Collector<? super Map.Entry<? extends K, ? extends V>, ?, M> toMap(BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, mapSupplier);
    }

    public Optional<Map.Entry<K, V>> max(Comparator<? super Map.Entry<K, V>> var1);

    public Optional<Map.Entry<K, V>> maxByKey(Comparator<? super K> var1);

    public Optional<Map.Entry<K, V>> maxByValue(Comparator<? super V> var1);

    public Optional<Map.Entry<K, V>> min(Comparator<? super Map.Entry<K, V>> var1);

    public Optional<Map.Entry<K, V>> minByKey(Comparator<? super K> var1);

    public Optional<Map.Entry<K, V>> minByValue(Comparator<? super V> var1);

    public Optional<Map.Entry<K, V>> findAny();

    public Optional<Map.Entry<K, V>> findFirst();

    public Map.Entry<K, V>[] toArray();

    public MapStream<K, V> takeWhile(BiPredicate<? super K, ? super V> var1);

    public MapStream<K, V> takeWhileKey(Predicate<? super K> var1);

    public MapStream<K, V> takeWhileValue(Predicate<? super V> var1);

    public MapStream<K, V> dropWhile(BiPredicate<? super K, ? super V> var1);

    public MapStream<K, V> dropWhileKey(Predicate<? super K> var1);

    public MapStream<K, V> dropWhileValue(Predicate<? super V> var1);
}

