/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.ui.internal.catalog.ImageFactory;
import org.eclipse.wst.xml.ui.internal.dialogs.XMLCatalogTableViewer;

public class XMLCatalogEntryLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object object, int columnIndex) {
        Image result = null;
        if (columnIndex == 0) {
            Image base = null;
            if (object instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)object;
                String uri = catalogEntry.getURI();
                base = uri.endsWith("dtd") ? XMLCatalogTableViewer.dtdFileImage : (uri.endsWith("xsd") ? XMLCatalogTableViewer.xsdFileImage : XMLCatalogTableViewer.unknownFileImage);
                if (base != null) {
                    result = URIHelper.isReadableURI((String)uri, (boolean)false) ? base : base;
                }
            } else if (object instanceof String) {
                result = ImageFactory.INSTANCE.getImage("icons/obj16/xmlcatalog_obj.gif");
            }
        }
        return result;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public String getColumnText(Object object, int columnIndex) {
        String result = null;
        if (object instanceof ICatalogEntry) {
            ICatalogEntry catalogEntry = (ICatalogEntry)object;
            result = columnIndex == 0 ? catalogEntry.getKey() : catalogEntry.getURI();
            result = URIHelper.removePlatformResourceProtocol((String)result);
        }
        return result != null ? result : (columnIndex == 0 ? object.toString() : "");
    }
}

