/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddToFavoritesAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class AddServiceToFavoritesAction
extends AddToFavoritesAction {
    public AddServiceToFavoritesAction(Controller controller) {
        super(controller);
    }

    @Override
    public boolean favoriteExists() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement selectedElement = (WsilElement)selectedNode.getTreeElement();
        Object obj = selectedElement.getAllUDDIServices().getElementWithViewId(viewID).getObject();
        WsilUddiServiceElement wsilUddiServiceElement = (WsilUddiServiceElement)((Object)obj);
        String serviceName = wsilUddiServiceElement.getName();
        String inquiryAPI = wsilUddiServiceElement.getUDDIServiceInquiryAPI();
        String serviceKey = wsilUddiServiceElement.getUDDIServiceKey();
        if (serviceName == null) {
            serviceName = serviceKey;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIServiceName", serviceName);
        table.put("UDDIServiceInquiryAPI", inquiryAPI);
        table.put("UDDIServiceKey", serviceKey);
        return this.favoriteExists(table, "relUDDIServiceFolderNode");
    }

    @Override
    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "uddiServices", "viewId", 2);
        return transformers;
    }

    @Override
    public boolean executeSingleLinkAction() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement selectedElement = (WsilElement)selectedNode.getTreeElement();
        Object obj = selectedElement.getAllUDDIServices().getElementWithViewId(viewID).getObject();
        WsilUddiServiceElement wsilUddiServiceElement = (WsilUddiServiceElement)((Object)obj);
        String serviceName = wsilUddiServiceElement.getName();
        String inquiryAPI = wsilUddiServiceElement.getUDDIServiceInquiryAPI();
        String serviceKey = wsilUddiServiceElement.getUDDIServiceKey();
        if (serviceName == null) {
            serviceName = serviceKey;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIServiceName", serviceName);
        table.put("UDDIServiceInquiryAPI", inquiryAPI);
        table.put("UDDIServiceKey", serviceKey);
        if (this.isMultipleLinkAction() && this.favoriteExists(table, "relUDDIServiceFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_FAVORITES_ALREADY_EXISTS", serviceName));
            return false;
        }
        if (this.addToFavorites(table, "relUDDIServiceFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_TO_FAVORITES_SUCCESSFUL", serviceName));
            return true;
        }
        wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_TO_FAVORITES", serviceName));
        return false;
    }
}

