/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.geometry;

import java.lang.reflect.Field;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.CSpinner;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class AbstractGeometryDialog
extends Dialog {
    private final String m_title;
    private final Object m_object;
    private Composite m_area;

    public AbstractGeometryDialog(String title, Object object) {
        super(DesignerPlugin.getShell());
        this.m_title = title;
        this.m_object = object;
    }

    protected final Control createDialogArea(Composite parent) {
        this.m_area = new Composite(parent, 0);
        GridDataFactory.create((Control)this.m_area).grab().fill();
        GridLayoutFactory.create(this.m_area).margins(10).columns(3);
        this.createEditors();
        return this.m_area;
    }

    protected abstract void createEditors();

    protected final void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 9, ModelMessages.AbstractGeometryDialog_defaultButton, false);
        super.createButtonsForButtonBar(parent);
    }

    protected final void buttonPressed(int buttonId) {
        if (buttonId == 9) {
            this.setReturnCode(buttonId);
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected final void createEditor(String title, String fieldName) {
        Label titleLabel = new Label(this.m_area, 0);
        GridDataFactory.create((Control)titleLabel).hintHC(15);
        titleLabel.setText(title);
        final CSpinner spinner = new CSpinner(this.m_area, 2048);
        GridDataFactory.create((Control)spinner).hintHC(8).grabH().fillH();
        spinner.setMinimum(0);
        spinner.setMaximum(Integer.MAX_VALUE);
        try {
            final Field field = ReflectionUtils.getFieldByName(this.m_object.getClass(), fieldName);
            int value = field.getInt(this.m_object);
            spinner.setSelection(value);
            spinner.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        field.setInt(AbstractGeometryDialog.this.m_object, spinner.getSelection());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Label pixelsLabel = new Label(this.m_area, 0);
        pixelsLabel.setText(ModelMessages.AbstractGeometryDialog_pixelsLabel);
    }
}

