/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security;

import java.util.List;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityPlugin;
import org.eclipse.rse.internal.dstore.security.wizards.SystemImportCertAction;
import org.eclipse.swt.widgets.Display;

public class UniversalKeystoreProvider
implements ISystemKeystoreProvider {
    public String getKeyStorePassword() {
        return UniversalSecurityPlugin.getKeyStorePassword();
    }

    public String getKeyStorePath() {
        return UniversalSecurityPlugin.getKeyStoreLocation();
    }

    public boolean importCertificates(List certs, String systemName) {
        Display display = Display.getDefault();
        ImportCertificateRunnable impRun = new ImportCertificateRunnable(this, certs, systemName);
        display.syncExec((Runnable)impRun);
        return !impRun.wasCancelled();
    }

    public class ImportCertificateRunnable
    implements Runnable {
        private List _certificates;
        private ISystemKeystoreProvider _provider;
        private boolean _wasCancelled = false;
        private String _systemName;

        public ImportCertificateRunnable(ISystemKeystoreProvider provider, List certs, String systemName) {
            this._certificates = certs;
            this._provider = provider;
            this._systemName = systemName;
        }

        public boolean wasCancelled() {
            return this._wasCancelled;
        }

        public void run() {
            SystemImportCertAction importAction = new SystemImportCertAction(this._provider, this._certificates, this._systemName);
            importAction.run();
            this._wasCancelled = importAction.wasCancelled();
        }
    }
}

