/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.preferences.launcher;

import jakarta.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.core.launch.ScriptLauncherManager;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseAdapter;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPlugin;
import org.eclipse.php.composer.ui.preferences.launcher.ExecutableTester;
import org.eclipse.php.composer.ui.preferences.launcher.LauncherKeyBag;
import org.eclipse.php.composer.ui.preferences.launcher.Messages;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsPreferencePage;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.wizards.fields.ComboDialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class LauncherConfigurationBlock
extends OptionsConfigurationBlock
implements IDialogFieldListener {
    protected final Key phpExecutable;
    protected final Key scriptToExecute;
    protected final Key useScriptInsideProject;
    protected final String pluginID;
    protected Group scriptGroup;
    protected ComboDialogField exes;
    protected Button testButton;
    protected PHPexes phpExes;
    protected SelectionButtonDialogFieldGroup buttonGroup;
    protected StringButtonDialogField scriptField;
    protected IProject project;
    @Inject
    public ScriptLauncherManager manager;

    public LauncherConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, LauncherKeyBag keyBag) {
        super(context, project, keyBag.getAllKeys(), container);
        this.phpExecutable = keyBag.getPHPExecutableKey();
        this.scriptToExecute = keyBag.getScriptKey();
        this.useScriptInsideProject = keyBag.getUseProjectKey();
        this.pluginID = this.getPluginId();
        this.project = project;
        ContextInjectionFactory.inject((Object)((Object)this), (IEclipseContext)ComposerUIPlugin.getDefault().getEclipseContext());
    }

    protected abstract String getPluginId();

    protected abstract void afterSave();

    protected abstract void beforeSave();

    protected abstract String getHeaderLabel();

    protected abstract String getProjectChoiceLabel();

    protected abstract String getGlobalChoiceLabel();

    protected abstract String getScriptLabel();

    protected abstract String getButtonGroupLabel();

    protected abstract String getScriptFieldLabel();

    protected abstract boolean validateScript(String var1);

    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Label header = new Label(parent, 0);
        header.setText(this.getHeaderLabel());
        Composite markersComposite = this.createInnerContent(parent);
        this.validateSettings(null, null, null);
        return markersComposite;
    }

    protected Composite createInnerContent(Composite folder) {
        Composite result = new Composite(folder, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = 440;
        result.setLayoutData((Object)gd);
        gd = new GridData(768);
        Group sourceFolderGroup = new Group(result, 0);
        sourceFolderGroup.setLayout((Layout)new GridLayout(3, false));
        sourceFolderGroup.setLayoutData((Object)gd);
        sourceFolderGroup.setText(Messages.LauncherConfigurationBlock_Title);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        Link prefLink = new Link((Composite)sourceFolderGroup, 64);
        prefLink.setText(Messages.LauncherConfigurationBlock_PhpExesLink);
        prefLink.setLayoutData((Object)gridData);
        prefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPreferenceContainer container = LauncherConfigurationBlock.this.getPreferenceContainer();
                container.openPage(PHPsPreferencePage.ID, null);
            }
        });
        Link helpLink = new Link((Composite)sourceFolderGroup, 64);
        helpLink.setLayoutData((Object)gridData);
        helpLink.setText(Messages.LauncherConfigurationBlock_HelpLink);
        helpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("http://www.phptherightway.com/#getting_started"));
                }
                catch (Exception e1) {
                    Logger.logException((Throwable)e1);
                }
            }
        });
        this.exes = new ComboDialogField(8);
        this.exes.setLabelText(Messages.LauncherConfigurationBlock_PhpExeLabel);
        this.exes.doFillIntoGrid((Composite)sourceFolderGroup, 2);
        this.exes.setDialogFieldListener((IDialogFieldListener)this);
        this.createTestButton((Composite)sourceFolderGroup);
        this.loadExecutables();
        this.createScriptGroup(result);
        this.loadPhar();
        if (this.phpExes.getAllItems().length == 0) {
            this.testButton.setEnabled(false);
        }
        this.createExtraContent(result);
        return result;
    }

    protected void createScriptGroup(Composite result) {
        GridData gd = new GridData(768);
        this.scriptGroup = new Group(result, 0);
        this.scriptGroup.setLayout((Layout)new GridLayout(3, false));
        this.scriptGroup.setLayoutData((Object)gd);
        this.scriptGroup.setText(this.getScriptLabel());
        this.buttonGroup = new SelectionButtonDialogFieldGroup(16, new String[]{this.getProjectChoiceLabel(), this.getGlobalChoiceLabel()}, 2);
        this.buttonGroup.setLabelText(this.getButtonGroupLabel());
        this.buttonGroup.doFillIntoGrid((Composite)this.scriptGroup, 3);
        this.buttonGroup.setDialogFieldListener(new org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                LauncherConfigurationBlock.this.scriptField.setEnabled(LauncherConfigurationBlock.this.buttonGroup.isSelected(1));
            }
        });
        this.scriptField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(org.eclipse.php.internal.ui.wizards.fields.DialogField field) {
                FileDialog dialog = new FileDialog(LauncherConfigurationBlock.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    LauncherConfigurationBlock.this.scriptField.setText(path);
                }
            }
        });
        this.scriptField.setButtonLabel(Messages.LauncherConfigurationBlock_BrowseButton);
        boolean useProjectPhar = this.getBooleanValue(this.useScriptInsideProject);
        if (useProjectPhar) {
            this.scriptField.setEnabled(false);
            this.buttonGroup.setSelection(0, true);
            this.buttonGroup.setSelection(1, false);
        } else {
            this.buttonGroup.setSelection(0, false);
            this.buttonGroup.setSelection(1, true);
        }
        this.scriptField.setDialogFieldListener((IDialogFieldListener)this);
        this.scriptField.setLabelText(this.getScriptFieldLabel());
        this.scriptField.doFillIntoGrid((Composite)this.scriptGroup, 3);
    }

    protected void createExtraContent(Composite result) {
    }

    private void loadPhar() {
        String phar = this.getValue(this.scriptToExecute);
        if (phar == null) {
            return;
        }
        this.scriptField.setText(phar);
    }

    protected void loadExecutables() {
        this.phpExes = PHPexes.getInstance();
        String current = this.getValue(this.phpExecutable);
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        int select = -1;
        PHPexeItem[] pHPexeItemArray = this.phpExes.getAllItems();
        int n = pHPexeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if (item.isDefault() && (current == null || current.length() == 0) || item.getExecutable().toString().equals(current)) {
                select = i;
            }
            ++i;
            items.add(item.getName());
            ++n2;
        }
        this.exes.setItems(items.toArray(new String[items.size()]));
        if (select > -1) {
            this.exes.selectItem(select);
        }
    }

    protected void createTestButton(Composite parent) {
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.testButton = new Button(parent, 8);
        this.testButton.setLayoutData((Object)gd);
        this.testButton.setText(Messages.LauncherConfigurationBlock_TestButton);
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String current = LauncherConfigurationBlock.this.exes.getText();
                    PHPexeItem phPexeItem = null;
                    PHPexeItem[] pHPexeItemArray = LauncherConfigurationBlock.this.phpExes.getAllItems();
                    int n = pHPexeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PHPexeItem i = pHPexeItemArray[n2];
                        if (current.equals(i.getName())) {
                            phPexeItem = i;
                            break;
                        }
                        ++n2;
                    }
                    if (phPexeItem == null) {
                        Logger.log((int)2, (String)"No executable selected");
                        return;
                    }
                    ExecutionResponseAdapter adapter = new ExecutionResponseAdapter(){

                        public void executionFailed(final String response, Exception exception) {
                            LauncherConfigurationBlock.this.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Object message = Messages.LauncherConfigurationBlock_ExecutionFailedMessage;
                                    if (response != null && response.length() > 0) {
                                        message = (String)message + NLS.bind((String)Messages.LauncherConfigurationBlock_ReasonMessage, (Object)response);
                                    }
                                    MessageDialog.openInformation((Shell)LauncherConfigurationBlock.this.getShell(), (String)Messages.LauncherConfigurationBlock_TestDialogTitle, (String)message);
                                }
                            });
                        }

                        public void executionFinished(final String response, int exitValue) {
                            LauncherConfigurationBlock.this.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Object message = Messages.LauncherConfigurationBlock_TestSuccessMessage;
                                    message = response != null && response.length() > 0 ? (String)message + NLS.bind((String)Messages.LauncherConfigurationBlock_DetectedVersionMessage, (Object)response) : (String)message + Messages.LauncherConfigurationBlock_CannotDetermineVersionMessage;
                                    MessageDialog.openInformation((Shell)LauncherConfigurationBlock.this.getShell(), (String)Messages.LauncherConfigurationBlock_TestDialogTitle, (String)message);
                                }
                            });
                        }
                    };
                    new Thread(new ExecutableTester(phPexeItem, (ExecutionResponseListener)adapter)).run();
                }
                catch (Exception ex) {
                    Logger.logException((Throwable)ex);
                }
            }
        });
    }

    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        StatusInfo status = new StatusInfo();
        if (this.phpExes.getAllItems().length == 0) {
            status = new StatusInfo(2, Messages.LauncherConfigurationBlock_NoPHPConfiguredError);
        }
        if (this.buttonGroup != null && this.buttonGroup.isSelected(1) && !this.validateScript(this.scriptField.getText())) {
            status = new StatusInfo(2, Messages.LauncherConfigurationBlock_InvalidPHPScriptError);
        }
        this.fContext.statusChanged((IStatus)status);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected final Key getCoreKey(String key) {
        return LauncherConfigurationBlock.getKey((String)this.pluginID, (String)key);
    }

    public void performDefaults() {
        this.scriptField.setText("");
        this.scriptField.setEnabled(false);
        if (this.buttonGroup != null) {
            this.buttonGroup.setSelection(0, true);
            this.buttonGroup.setSelection(1, false);
        }
        this.setValue(this.useScriptInsideProject, true);
        this.setValue(this.scriptToExecute, "");
        this.setValue(this.phpExecutable, "");
        this.validateSettings(null, null, null);
        super.performDefaults();
    }

    public boolean performApply() {
        this.saveExecutable();
        return super.performApply();
    }

    public boolean performOk() {
        this.saveExecutable();
        return super.performOk();
    }

    protected void saveExecutable() {
        this.beforeSave();
        String selected = this.exes.getText();
        String executable = null;
        PHPexeItem[] pHPexeItemArray = this.phpExes.getAllItems();
        int n = pHPexeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem exe = pHPexeItemArray[n2];
            if (exe.getName().equals(selected)) {
                executable = exe.getExecutable().getAbsolutePath();
            }
            ++n2;
        }
        this.setValue(this.phpExecutable, executable);
        this.setValue(this.scriptToExecute, this.scriptField.getText());
        this.setValue(this.useScriptInsideProject, this.doUseScriptInsideProject());
        this.afterSave();
    }

    protected boolean doUseScriptInsideProject() {
        return this.buttonGroup.isSelected(0);
    }

    public void dialogFieldChanged(org.eclipse.php.internal.ui.wizards.fields.DialogField field) {
        this.validateSettings(null, null, null);
    }
}

