/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;
import org.eclipse.ocl.examples.eventmanager.filters.AndFilter;
import org.eclipse.ocl.examples.eventmanager.filters.LogicalOperationFilter;
import org.eclipse.ocl.examples.eventmanager.filters.NotFilter;
import org.eclipse.ocl.examples.eventmanager.filters.OrFilter;
import org.eclipse.ocl.examples.eventmanager.framework.ListenerTypeEnum;
import org.eclipse.ocl.examples.eventmanager.framework.LogicalOperationFilterImpl;
import org.eclipse.ocl.examples.eventmanager.framework.Registration;
import org.eclipse.ocl.examples.eventmanager.framework.RegistrationSet;
import org.eclipse.ocl.examples.eventmanager.framework.TableForClassFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForClassFilterIncludingSubClasses;
import org.eclipse.ocl.examples.eventmanager.framework.TableForContainmentFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForEventFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForEventTypeFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForNewValueClassFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForNewValueClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.framework.TableForOldValueClassFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForOldValueClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.framework.TableForStructuralFeatureFilter;
import org.eclipse.ocl.examples.eventmanager.util.Bag;
import org.eclipse.ocl.examples.eventmanager.util.Statistics;

public class RegistrationManagerTableBased {
    private Logger logger = Logger.getLogger(RegistrationManagerTableBased.class.getName());
    private final HashMap<Integer, Set<TableForEventFilter>> tablesByEventType = new HashMap();
    private final HashMap<Object, TableForEventFilter> tableByFilterType = new HashMap();
    private final WeakHashMap<Adapter, Set<Reference<? extends Adapter>>> adaptersToWeakRefs = new WeakHashMap();
    private final Map<Reference<? extends Adapter>, List<RegistrationSet>> registrationSetByListenerReference = new HashMap<Reference<? extends Adapter>, List<RegistrationSet>>();
    private Map<AndFilter, Registration> allRegistrations = new HashMap<AndFilter, Registration>();
    private int[] bitSetsWithAtLeastOneRegistration;
    private int numberOfBitSetsWithAtLeastOneRegistration;
    private TableForEventFilter[] allTables;
    protected TableForEventFilter eventTypeFilterTable = null;
    protected Set<TableForEventFilter> tablesWithNegatedRegistrations = new HashSet<TableForEventFilter>();
    private Map<Class<? extends EventFilter>, Integer> filterTypeToBitMask;
    private final Map<TableForEventFilter, Integer> tableToIndexInAllTables = new HashMap<TableForEventFilter, Integer>();

    public RegistrationManagerTableBased() {
        this.init();
    }

    protected void init() {
        this.filterTypeToBitMask = new HashMap<Class<? extends EventFilter>, Integer>();
        Class[] tableTypes = new Class[]{TableForStructuralFeatureFilter.class, TableForClassFilter.class, TableForClassFilterIncludingSubClasses.class, TableForEventTypeFilter.class, TableForContainmentFilter.class, TableForNewValueClassFilter.class, TableForOldValueClassFilter.class, TableForNewValueClassFilterIncludingSubclasses.class, TableForOldValueClassFilterIncludingSubclasses.class};
        this.createAllTables(tableTypes.length);
        int i = 0;
        Class[] classArray = tableTypes;
        int n = tableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TableForEventFilter table;
            Class tableType = classArray[n2];
            try {
                Constructor constructor = tableType.getConstructor(Integer.TYPE);
                table = (TableForEventFilter)constructor.newInstance(tableTypes.length);
            }
            catch (Exception e) {
                throw new RuntimeException("Didn't find constructor(int) on table type " + tableType.getSimpleName(), e);
            }
            this.setUsualEvents(table);
            this.registerTable(table, i++);
            ++n2;
        }
    }

    protected void createAllTables(int size) {
        this.allTables = new TableForEventFilter[size];
        this.bitSetsWithAtLeastOneRegistration = new int[1 << size];
        this.numberOfBitSetsWithAtLeastOneRegistration = 0;
    }

    private void setUsualEvents(TableForEventFilter table) {
        this.addTableForEventType(table, 1);
        this.addTableForEventType(table, 2);
        this.addTableForEventType(table, 3);
        this.addTableForEventType(table, 4);
        this.addTableForEventType(table, 5);
        this.addTableForEventType(table, 6);
        this.addTableForEventType(table, 7);
    }

    public synchronized void register(EventFilter filterTree, WeakReference<? extends Adapter> listener, ListenerTypeEnum listenerType) {
        if (!(filterTree instanceof OrFilter) && !(filterTree instanceof AndFilter)) {
            EventFilter topOfTree;
            filterTree = topOfTree = EventManagerFactory.eINSTANCE.createAndFilterFor(filterTree);
        }
        OrFilter filterInNormalForm = RegistrationManagerTableBased.getDisjunctiveNormalForm((LogicalOperationFilterImpl)filterTree);
        LinkedList<Registration> registrations = new LinkedList<Registration>();
        for (EventFilter filter : filterInNormalForm.getOperands()) {
            AndFilter andFilter = (AndFilter)filter;
            Registration reg = this.allRegistrations.get(andFilter);
            if (reg == null) {
                reg = this.createRegistration(andFilter);
            }
            registrations.add(reg);
        }
        RegistrationSet result = new RegistrationSet(listener, listenerType, registrations);
        this.addRegistrationForListener(result, listener);
    }

    private Registration createRegistration(AndFilter andFilter) {
        int[] requiredMatchesPerTable = new int[this.allTables.length];
        Map<EventFilter, TableForEventFilter> filterTablesToRegisterWith = this.getFilterTablesToRegisterWith(andFilter, requiredMatchesPerTable);
        Registration result = new Registration(this.getBitSet(filterTablesToRegisterWith.values()), andFilter, requiredMatchesPerTable);
        this.allRegistrations.put(andFilter, result);
        this.updateBitSetsWithAtLeastOneRegistration(result);
        for (Map.Entry<EventFilter, TableForEventFilter> filterTableEntry : filterTablesToRegisterWith.entrySet()) {
            filterTableEntry.getValue().register(filterTableEntry.getKey(), result);
        }
        return result;
    }

    private void updateBitSetsWithAtLeastOneRegistration(Registration registration) {
        int bitset = registration.getBitSetForTablesRegisteredWith();
        int i = 0;
        while (i < this.numberOfBitSetsWithAtLeastOneRegistration) {
            if (this.bitSetsWithAtLeastOneRegistration[i] == bitset) {
                return;
            }
            ++i;
        }
        this.bitSetsWithAtLeastOneRegistration[this.numberOfBitSetsWithAtLeastOneRegistration++] = bitset;
    }

    private Map<EventFilter, TableForEventFilter> getFilterTablesToRegisterWith(AndFilter andFilter, int[] requiredMatchesPerTable) {
        HashMap<EventFilter, TableForEventFilter> filterTablesToRegisterWith = new HashMap<EventFilter, TableForEventFilter>();
        AndFilter level1OfTree = andFilter;
        for (EventFilter leafOfTree : level1OfTree.getOperands()) {
            TableForEventFilter filterTable = this.getFilterTable(leafOfTree);
            if (filterTable == null) {
                throw new IllegalArgumentException("no table for type " + leafOfTree.getClass() + " in RegistryManager defined");
            }
            int n = this.tableToIndexInAllTables.get(filterTable);
            requiredMatchesPerTable[n] = requiredMatchesPerTable[n] + 1;
            filterTablesToRegisterWith.put(leafOfTree, filterTable);
        }
        return filterTablesToRegisterWith;
    }

    private void addRegistrationForListener(RegistrationSet registrationSet, Reference<? extends Adapter> listenerRef) {
        Adapter adapter = listenerRef.get();
        if (adapter == null) {
            this.logger.warning("Registered adapter got GCed: " + listenerRef);
        } else {
            Set<Reference<? extends Adapter>> listenerSet = this.adaptersToWeakRefs.get(adapter);
            if (listenerSet == null) {
                listenerSet = new HashSet<Reference<? extends Adapter>>();
                this.adaptersToWeakRefs.put(adapter, listenerSet);
            }
            listenerSet.add(listenerRef);
            List<RegistrationSet> registrationSetList = this.registrationSetByListenerReference.get(listenerRef);
            if (registrationSetList == null) {
                registrationSetList = new ArrayList<RegistrationSet>();
                this.registrationSetByListenerReference.put(listenerRef, registrationSetList);
            }
            registrationSetList.add(registrationSet);
        }
    }

    private int getBitSet(Collection<TableForEventFilter> tables) {
        int result = 0;
        for (TableForEventFilter table : tables) {
            result |= this.filterTypeToBitMask.get(table.getIdentifier()).intValue();
        }
        return result;
    }

    private void deregister(RegistrationSet rs) {
        for (Registration reg : rs.getRegistrations()) {
            if (!reg.removeRegistrationSet(rs)) continue;
            this.deregister(reg);
        }
    }

    public synchronized void deregister(Adapter listener) {
        Set<Reference<? extends Adapter>> set = this.adaptersToWeakRefs.get(listener);
        if (set != null) {
            for (Reference<? extends Adapter> listenerRef : set) {
                this.deregister(listenerRef);
            }
        }
    }

    public synchronized void deregister(Reference<? extends Adapter> listenerRef) {
        List<RegistrationSet> registrationSets;
        Adapter adapter = listenerRef.get();
        if (adapter != null) {
            this.adaptersToWeakRefs.remove(adapter);
        }
        if ((registrationSets = this.registrationSetByListenerReference.get(listenerRef)) != null) {
            for (RegistrationSet registrationSet : registrationSets) {
                this.deregister(registrationSet);
            }
            this.registrationSetByListenerReference.remove(listenerRef);
        }
    }

    public Collection<WeakReference<? extends Adapter>> getListenersFor(Notification event) {
        Set<Registration> registrations = this.getRegistrationsFor(event);
        LinkedList<WeakReference<? extends Adapter>> result = new LinkedList<WeakReference<? extends Adapter>>();
        HashSet<RegistrationSet> registrationSetsAddedSoFar = new HashSet<RegistrationSet>();
        for (Registration reg : registrations) {
            for (RegistrationSet registrationSet : reg.getRegistrationSets()) {
                if (registrationSetsAddedSoFar.contains(registrationSet)) continue;
                registrationSetsAddedSoFar.add(registrationSet);
                result.add(registrationSet.getListener());
            }
        }
        return result;
    }

    private Set<Registration> getRegistrationsFor(Notification event) {
        Statistics.getInstance().begin("getRegistrationsFor", event);
        HashSet<Registration> result = new HashSet<Registration>();
        Bag[][] yesSetsForTables = new Bag[this.allTables.length][];
        Bag[][] noSetsForTables = new Bag[this.allTables.length][];
        int i = 0;
        TableForEventFilter[] tableForEventFilterArray = this.allTables;
        int n = this.allTables.length;
        int n2 = 0;
        while (n2 < n) {
            TableForEventFilter table = tableForEventFilterArray[n2];
            Bag<Registration>[] yesSetsForTable = table.getYesSetsFor(event, this.numberOfBitSetsWithAtLeastOneRegistration, this.bitSetsWithAtLeastOneRegistration);
            yesSetsForTables[i] = yesSetsForTable;
            Bag<Registration>[] noSetsForTable = table.getNoSetsFor(event, this.numberOfBitSetsWithAtLeastOneRegistration, this.bitSetsWithAtLeastOneRegistration);
            noSetsForTables[i] = noSetsForTable;
            ++i;
            ++n2;
        }
        HashSet<Registration> startSetToReuseToAvoidHashSetCreation = new HashSet<Registration>();
        int bitSetIndex = 0;
        while (bitSetIndex < this.numberOfBitSetsWithAtLeastOneRegistration) {
            this.addIntersectionOverTablesInBitset_Of_YesSetUnitedWithAllNoSetMinusNoSet(this.bitSetsWithAtLeastOneRegistration[bitSetIndex], yesSetsForTables, noSetsForTables, result, startSetToReuseToAvoidHashSetCreation);
            ++bitSetIndex;
        }
        Statistics.getInstance().end("getRegistrationsFor", event);
        return result;
    }

    private void addIntersectionOverTablesInBitset_Of_YesSetUnitedWithAllNoSetMinusNoSet(int bitSetForTableCombination, Bag<Registration>[][] yesSetsForTables, Bag<Registration>[][] noSetsForTables, Set<Registration> result, HashSet<Registration> startSetToReuseToAvoidHashSetCreation) {
        int tableWithMinSize = this.getTableWithMinSizeForIntersection(bitSetForTableCombination, yesSetsForTables);
        Collection<Registration> resultForTablesInBitSet = this.getStartCollectionFromMinSizeTable(bitSetForTableCombination, yesSetsForTables, noSetsForTables, tableWithMinSize, startSetToReuseToAvoidHashSetCreation);
        if (!resultForTablesInBitSet.isEmpty()) {
            int i = this.allTables.length - 1;
            while (i >= 0) {
                if (i != tableWithMinSize && (bitSetForTableCombination & 1 << i) != 0) {
                    Iterator<Registration> resultIter = resultForTablesInBitSet.iterator();
                    while (resultIter.hasNext()) {
                        Registration next = resultIter.next();
                        if (this.is_InYesOrCompleteNo_And_NotInNo_OfTable(next, i, bitSetForTableCombination, yesSetsForTables, noSetsForTables)) continue;
                        resultIter.remove();
                    }
                }
                --i;
            }
        }
        result.addAll(resultForTablesInBitSet);
    }

    private Collection<Registration> getStartCollectionFromMinSizeTable(int bitSetForTableCombination, Bag<Registration>[][] yesSetsForTables, Bag<Registration>[][] noSetsForTables, int tableWithMinSize, HashSet<Registration> resultForTablesInBitSet) {
        resultForTablesInBitSet.clear();
        Bag<Registration> yesSetForMinSizeTable = yesSetsForTables[tableWithMinSize][bitSetForTableCombination];
        Bag<Registration> allNoForMinSizeTable = this.allTables[tableWithMinSize].getCompleteNoBag()[bitSetForTableCombination];
        Bag<Registration> noSetForMinSizeTable = noSetsForTables[tableWithMinSize][bitSetForTableCombination];
        if (yesSetForMinSizeTable != null) {
            for (Registration r : yesSetForMinSizeTable) {
                if (noSetForMinSizeTable != null && noSetForMinSizeTable.contains(r) || r.getMatchesRequiredForTable(tableWithMinSize) != yesSetForMinSizeTable.count(r) + (allNoForMinSizeTable == null ? 0 : allNoForMinSizeTable.count(r))) continue;
                resultForTablesInBitSet.add(r);
            }
        }
        if (allNoForMinSizeTable != null) {
            for (Registration r : allNoForMinSizeTable) {
                if (noSetForMinSizeTable != null && noSetForMinSizeTable.contains(r) || r.getMatchesRequiredForTable(tableWithMinSize) != (yesSetForMinSizeTable == null ? 0 : yesSetForMinSizeTable.count(r)) + allNoForMinSizeTable.count(r)) continue;
                resultForTablesInBitSet.add(r);
            }
        }
        return resultForTablesInBitSet;
    }

    private int getTableWithMinSizeForIntersection(int bitSetForTableCombination, Bag<Registration>[][] yesSetsForTables) {
        int[] maxSizes = new int[this.allTables.length];
        int minSize = Integer.MAX_VALUE;
        int tableWithMinSize = -1;
        int tableBit = 1 << this.allTables.length - 1;
        int i = this.allTables.length - 1;
        while (i >= 0) {
            if ((bitSetForTableCombination & tableBit) != 0) {
                Bag<Registration> yesSet = yesSetsForTables[i][bitSetForTableCombination];
                Bag<Registration> allNo = this.allTables[i].getCompleteNoBag()[bitSetForTableCombination];
                maxSizes[i] = (yesSet == null ? 0 : yesSet.size()) + (allNo == null ? 0 : allNo.size());
                if (maxSizes[i] < minSize) {
                    minSize = maxSizes[i];
                    tableWithMinSize = i;
                }
            }
            tableBit >>= 1;
            --i;
        }
        return tableWithMinSize;
    }

    private boolean is_InYesOrCompleteNo_And_NotInNo_OfTable(Registration registration, int table, int bitSetForTableCombination, Bag<Registration>[][] yesSetsForTable, Bag<Registration>[][] noSetsForTables) {
        Bag<Registration> yesSet = yesSetsForTable[table][bitSetForTableCombination];
        Bag<Registration> allNo = this.allTables[table].getCompleteNoBag()[bitSetForTableCombination];
        Bag<Registration> noSet = noSetsForTables[table][bitSetForTableCombination];
        return yesSet != null && (noSet == null || !noSet.contains(registration)) && registration.getMatchesRequiredForTable(table) == yesSet.count(registration) + (allNo == null ? 0 : allNo.count(registration)) || allNo != null && (noSet == null || !noSet.contains(registration)) && registration.getMatchesRequiredForTable(table) == (yesSet == null ? 0 : yesSet.count(registration)) + allNo.count(registration);
    }

    public boolean isListenerRegistered(Adapter listener) {
        return this.adaptersToWeakRefs.containsKey(listener);
    }

    private void deregister(Registration registration) {
        TableForEventFilter[] tableForEventFilterArray = this.allTables;
        int n = this.allTables.length;
        int n2 = 0;
        while (n2 < n) {
            TableForEventFilter table = tableForEventFilterArray[n2];
            table.deregister(registration);
            if (table.isEmpty()) {
                this.tablesWithNegatedRegistrations.remove(table);
            }
            ++n2;
        }
        this.allRegistrations.remove(registration.getAndFilter());
        this.rebuildBitSetsWithAtLeastOneRegistration();
    }

    private void rebuildBitSetsWithAtLeastOneRegistration() {
        HashSet<Integer> bitSetsInUse = new HashSet<Integer>();
        for (Registration r : this.allRegistrations.values()) {
            bitSetsInUse.add(r.getBitSetForTablesRegisteredWith());
        }
        this.numberOfBitSetsWithAtLeastOneRegistration = bitSetsInUse.size();
        int i = 0;
        Iterator iterator = bitSetsInUse.iterator();
        while (iterator.hasNext()) {
            int bitSetInUse = (Integer)iterator.next();
            this.bitSetsWithAtLeastOneRegistration[i++] = bitSetInUse;
        }
    }

    private TableForEventFilter getFilterTable(EventFilter filter) {
        return this.tableByFilterType.get(filter.getClass());
    }

    protected void addTableForEventType(TableForEventFilter table, Integer eventType) {
        Set<TableForEventFilter> tables = this.tablesByEventType.get(eventType);
        if (tables == null) {
            tables = new HashSet<TableForEventFilter>();
            this.tablesByEventType.put(eventType, tables);
        }
        tables.add(table);
    }

    public static OrFilter getDisjunctiveNormalForm(LogicalOperationFilterImpl filter) {
        if (RegistrationManagerTableBased.isInDisjunctiveNormalForm(filter)) {
            return (OrFilter)filter;
        }
        LogicalOperationFilterImpl result = filter;
        result = (LogicalOperationFilterImpl)RegistrationManagerTableBased.eliminateNegations(result);
        if (RegistrationManagerTableBased.isInDisjunctiveNormalForm(result = (LogicalOperationFilterImpl)RegistrationManagerTableBased.getExpandedSubTree(null, result))) {
            return (OrFilter)result;
        }
        result = (LogicalOperationFilterImpl)RegistrationManagerTableBased.getExpandedSubTree(null, result);
        if (RegistrationManagerTableBased.getDepth(result) < 2) {
            if (result instanceof OrFilter) {
                OrFilter orfilter = new OrFilter();
                for (EventFilter operand : result.getOperands()) {
                    AndFilter tmp = new AndFilter(operand);
                    orfilter.addOperand(tmp);
                }
                result = orfilter;
            } else if (result instanceof AndFilter) {
                OrFilter tmp = new OrFilter(result);
                result = tmp;
            } else if (result instanceof NotFilter) {
                throw new IllegalStateException("Elimination of NotFilters failed");
            }
        }
        if (!RegistrationManagerTableBased.isInDisjunctiveNormalForm(result)) {
            if (result instanceof OrFilter) {
                Set<EventFilter> oldO = result.getOperands();
                OrFilter orfilter = new OrFilter();
                for (EventFilter f : oldO) {
                    if (!(f instanceof LogicalOperationFilter)) {
                        orfilter.addOperand(EventManagerFactory.eINSTANCE.createAndFilterFor(f));
                        continue;
                    }
                    orfilter.addOperand(f);
                }
                result = orfilter;
                if (!RegistrationManagerTableBased.isInDisjunctiveNormalForm(result)) {
                    throw new IllegalStateException("Could not create disjunctiv normal form");
                }
            } else {
                throw new IllegalStateException("Could not create disjunctiv normal form");
            }
        }
        return (OrFilter)result;
    }

    private static boolean isInDisjunctiveNormalForm(EventFilter filter) {
        if (!(filter instanceof OrFilter)) {
            return false;
        }
        for (EventFilter operand : ((LogicalOperationFilterImpl)filter).getOperands()) {
            if (!(operand instanceof AndFilter)) {
                return false;
            }
            for (EventFilter operandsOperand : ((LogicalOperationFilterImpl)operand).getOperands()) {
                if (!(operandsOperand instanceof OrFilter) && !(operandsOperand instanceof AndFilter)) continue;
                return false;
            }
        }
        return true;
    }

    private static EventFilter eliminateNegations(EventFilter filter) {
        if (filter instanceof NotFilter) {
            EventFilter operand = ((LogicalOperationFilterImpl)filter).getOperands().iterator().next();
            return RegistrationManagerTableBased.getNegatedSubTree(operand);
        }
        if (filter instanceof LogicalOperationFilterImpl) {
            ArrayList<EventFilter> oldOperands = new ArrayList<EventFilter>(((LogicalOperationFilterImpl)filter).getOperands());
            ((LogicalOperationFilterImpl)filter).clearOperands();
            for (EventFilter operand : oldOperands) {
                RegistrationManagerTableBased.addOperand((LogicalOperationFilterImpl)filter, RegistrationManagerTableBased.eliminateNegations(operand));
            }
            return filter;
        }
        return filter;
    }

    static EventFilter getExpandedSubTree(LogicalOperationFilterImpl parent, EventFilter filter) {
        boolean willBeShrinkedIfNotMultipliedOut;
        if (!(filter instanceof LogicalOperationFilterImpl)) {
            return filter;
        }
        LogicalOperationFilterImpl lof = (LogicalOperationFilterImpl)filter;
        Set<EventFilter> oldOperands = new HashSet<EventFilter>(lof.getOperands().size());
        oldOperands.addAll(lof.getOperands());
        lof.clearOperands();
        if (oldOperands.size() == 1 && oldOperands.iterator().next() instanceof LogicalOperationFilterImpl) {
            lof = oldOperands.iterator().next() instanceof AndFilter ? new AndFilter() : new OrFilter();
            oldOperands = ((LogicalOperationFilterImpl)oldOperands.iterator().next()).getOperands();
        }
        for (EventFilter operand : oldOperands) {
            EventFilter expandedSubtree = RegistrationManagerTableBased.getExpandedSubTree(lof, operand);
            if (lof.getClass().equals(expandedSubtree.getClass())) {
                lof.addOperands(((LogicalOperationFilterImpl)expandedSubtree).getOperands());
                continue;
            }
            RegistrationManagerTableBased.addOperand(lof, expandedSubtree);
        }
        boolean isDNFyet = parent == null && lof.getClass().equals(OrFilter.class);
        boolean bl = willBeShrinkedIfNotMultipliedOut = parent != null && parent.getClass().equals(lof.getClass());
        if (isDNFyet || willBeShrinkedIfNotMultipliedOut) {
            return lof;
        }
        return RegistrationManagerTableBased.multiplyOut(lof, new LinkedList<LogicalOperationFilterImpl>(), 0);
    }

    static long getLeafCount(EventFilter f) {
        if (f instanceof LogicalOperationFilterImpl) {
            long count = 0L;
            for (EventFilter o : ((LogicalOperationFilterImpl)f).getOperands()) {
                count += RegistrationManagerTableBased.getLeafCount(o);
            }
            return count;
        }
        return 1L;
    }

    /*
     * WARNING - void declaration
     */
    private static LogicalOperationFilterImpl multiplyOut(LogicalOperationFilterImpl filter, List<LogicalOperationFilterImpl> intermediateResult, int index) {
        ArrayList<EventFilter> operands = new ArrayList<EventFilter>(filter.getOperands());
        if (operands.size() < 2) {
            return filter;
        }
        if (index == 0) {
            boolean moPossible = false;
            for (EventFilter operand : operands) {
                if (!(operand instanceof LogicalOperationFilterImpl)) continue;
                moPossible = true;
                break;
            }
            if (!moPossible) {
                return filter;
            }
            Set<Object> tmp1 = null;
            if (operands.get(0) instanceof LogicalOperationFilterImpl) {
                tmp1 = ((LogicalOperationFilterImpl)operands.get(0)).getOperands();
            } else {
                tmp1 = new HashSet(1);
                tmp1.add((EventFilter)operands.get(0));
            }
            Object var6_8 = null;
            if (operands.get(1) instanceof LogicalOperationFilterImpl) {
                Set<EventFilter> set = ((LogicalOperationFilterImpl)operands.get(1)).getOperands();
            } else {
                HashSet<EventFilter> hashSet = new HashSet<EventFilter>(1);
                hashSet.add((EventFilter)operands.get(1));
            }
            LogicalOperationFilterImpl lof = null;
            for (EventFilter eventFilter : tmp1) {
                void var6_11;
                for (EventFilter eventFilter2 : var6_11) {
                    lof = filter instanceof AndFilter ? new AndFilter(eventFilter, eventFilter2) : new OrFilter(eventFilter, eventFilter2);
                    intermediateResult.add(lof);
                }
            }
            return RegistrationManagerTableBased.multiplyOut(filter, intermediateResult, 2);
        }
        if (index >= operands.size()) {
            LogicalOperationFilterImpl result;
            try {
                result = RegistrationManagerTableBased.getSubstitutionForLogicalOperation(filter);
            }
            catch (Exception e) {
                result = null;
            }
            for (LogicalOperationFilterImpl lof : intermediateResult) {
                RegistrationManagerTableBased.addOperand(result, lof);
            }
            return result;
        }
        Set<Object> currentOperands = null;
        if (operands.get(index) instanceof LogicalOperationFilterImpl) {
            currentOperands = ((LogicalOperationFilterImpl)operands.get(index)).getOperands();
        } else {
            currentOperands = new HashSet(1);
            currentOperands.add((EventFilter)operands.get(index));
        }
        ArrayList<LogicalOperationFilterImpl> irClone = new ArrayList<LogicalOperationFilterImpl>(intermediateResult.size());
        irClone.addAll(intermediateResult);
        intermediateResult.clear();
        for (EventFilter eventFilter : currentOperands) {
            for (LogicalOperationFilterImpl logicalOperationFilterImpl : irClone) {
                LogicalOperationFilterImpl logicalOperationFilterImpl2 = (LogicalOperationFilterImpl)logicalOperationFilterImpl.clone();
                RegistrationManagerTableBased.addOperand(logicalOperationFilterImpl2, eventFilter);
                intermediateResult.add(logicalOperationFilterImpl2);
            }
        }
        return RegistrationManagerTableBased.multiplyOut(filter, intermediateResult, index + 1);
    }

    private static LogicalOperationFilterImpl getSubstitutionForLogicalOperation(LogicalOperationFilterImpl filter) {
        if (filter instanceof AndFilter) {
            return new OrFilter();
        }
        if (filter instanceof OrFilter) {
            return new AndFilter();
        }
        throw new IllegalStateException("Unknown logical substitution for " + filter.getClass());
    }

    public static int getDepth(LogicalOperationFilterImpl filter) {
        return RegistrationManagerTableBased.getDepth(filter, 1);
    }

    private static int getDepth(LogicalOperationFilterImpl filter, int level) {
        int result = 0;
        for (EventFilter currentFilter : filter.getOperands()) {
            if (!(currentFilter instanceof LogicalOperationFilterImpl)) continue;
            int nextLevel = level + 1;
            if (currentFilter instanceof NotFilter) {
                nextLevel = level;
            }
            result = Math.max(result, RegistrationManagerTableBased.getDepth((LogicalOperationFilterImpl)currentFilter, nextLevel));
        }
        return result + level;
    }

    private static EventFilter getNegatedSubTree(EventFilter filter) {
        if (filter instanceof NotFilter) {
            EventFilter result = new ArrayList<EventFilter>(((LogicalOperationFilterImpl)filter).getOperands()).get(0);
            return RegistrationManagerTableBased.getNegatedSubTree(RegistrationManagerTableBased.getNegatedSubTree(result));
        }
        if (filter instanceof LogicalOperationFilterImpl) {
            LogicalOperationFilterImpl result = RegistrationManagerTableBased.getSubstitutionForLogicalOperation((LogicalOperationFilterImpl)filter);
            for (EventFilter operand : ((LogicalOperationFilterImpl)filter).getOperands()) {
                EventFilter negatedOperand = RegistrationManagerTableBased.getNegatedSubTree(operand);
                if (negatedOperand.getClass().equals(result.getClass())) {
                    result.addOperands(((LogicalOperationFilterImpl)negatedOperand).getOperands());
                    continue;
                }
                RegistrationManagerTableBased.addOperand(result, negatedOperand);
            }
            return result;
        }
        ((AbstractEventFilter)filter).setNegated(!filter.isNegated());
        return filter;
    }

    private static boolean addOperand(LogicalOperationFilterImpl filter, EventFilter operand) {
        filter.addOperand(operand);
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("RegistrationManager: (\n");
        boolean first = true;
        int i = 0;
        TableForEventFilter[] tableForEventFilterArray = this.allTables;
        int n = this.allTables.length;
        int n2 = 0;
        while (n2 < n) {
            TableForEventFilter table = tableForEventFilterArray[n2];
            if (!first) {
                result.append(",\n");
            } else {
                first = false;
            }
            result.append("(");
            result.append(i++);
            result.append(") ");
            result.append(table);
            ++n2;
        }
        result.append(')');
        return result.toString();
    }

    protected Set<Registration>[] createRegistrationSetArray() {
        return new Set[1 << this.filterTypeToBitMask.size()];
    }

    protected void registerTable(TableForEventFilter table, int posInAllTables) {
        this.allTables[posInAllTables] = table;
        this.tableByFilterType.put(table.getIdentifier(), table);
        this.filterTypeToBitMask.put(table.getIdentifier(), 1 << this.filterTypeToBitMask.size());
        this.tableToIndexInAllTables.put(table, posInAllTables);
    }

    protected Collection<TableForEventFilter> getTablesForBitSet(int bitSet) {
        ArrayList<TableForEventFilter> result = new ArrayList<TableForEventFilter>(this.allTables.length);
        int i = 1;
        TableForEventFilter[] tableForEventFilterArray = this.allTables;
        int n = this.allTables.length;
        int n2 = 0;
        while (n2 < n) {
            TableForEventFilter table = tableForEventFilterArray[n2];
            if ((bitSet & i) != 0) {
                result.add(table);
            }
            i <<= 1;
            ++n2;
        }
        return result;
    }

    public int redundantFilters() {
        HashMap<AndFilter, Registration> distinctAndFilters = new HashMap<AndFilter, Registration>();
        int result = 0;
        for (Registration ar : this.allRegistrations.values()) {
            if (!this.checkForRedundantFilterAndUpdateMapCorrespondingly(ar, distinctAndFilters)) continue;
            ++result;
        }
        return result;
    }

    private boolean checkForRedundantFilterAndUpdateMapCorrespondingly(Registration r, Map<AndFilter, Registration> distinctAndFilters) {
        boolean result;
        AndFilter andFilter = r.getAndFilter();
        Registration knownRegistrationWithEqualAndFilter = distinctAndFilters.get(andFilter);
        if (knownRegistrationWithEqualAndFilter == null) {
            distinctAndFilters.put(andFilter, r);
            result = false;
        } else {
            boolean bl = result = knownRegistrationWithEqualAndFilter != r;
            if (result && knownRegistrationWithEqualAndFilter.getBitSetForTablesRegisteredWith() != r.getBitSetForTablesRegisteredWith()) {
                throw new RuntimeException("Error: registrations with equal AndFilter have different bit set, saying they would end up in different tables");
            }
        }
        return result;
    }
}

