/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.File;
import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsProvider;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;

public class DefaultUnixConnectionSettingsProvider
implements IDockerConnectionSettingsProvider {
    @Override
    public List<IDockerConnectionSettings> getConnectionSettings() {
        Path unixSocketPath = Path.of("/var/run/docker.sock", new String[0]);
        File unixSocketFile = unixSocketPath.toFile();
        if (unixSocketFile.exists() && unixSocketFile.canRead() && unixSocketFile.canWrite()) {
            List<IDockerConnectionSettings> list;
            block9: {
                UnixDomainSocketAddress address = UnixDomainSocketAddress.of(unixSocketPath);
                SocketChannel channel = SocketChannel.open(address);
                try {
                    UnixSocketConnectionSettings socket = new UnixSocketConnectionSettings("unix:///var/run/docker.sock");
                    socket.setName(socket.getPath());
                    list = Arrays.asList(socket);
                    if (channel == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                channel.close();
            }
            return list;
        }
        return Collections.emptyList();
    }
}

