/*******************************************************************************
 * Copyright (c) 2005, 2016 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.console;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SocketScriptConsoleIO implements IScriptConsoleIO {
	private final Socket socket;

	private final IScriptConsoleIO io;

	public SocketScriptConsoleIO(Socket socket) throws IOException {
		this.socket = socket;

		BufferedOutputStream output = new BufferedOutputStream(socket
				.getOutputStream());

		io = new ScriptConsoleIO(socket.getInputStream(), output);
	}

	@Override
	public String getId() {
		return io.getId();
	}

	@Override
	public InterpreterResponse execInterpreter(String command)
			throws IOException {
		return io.execInterpreter(command);
	}

	@Override
	public ShellResponse execShell(String command, String[] args)
			throws IOException {
		return io.execShell(command, args);
	}

	@Override
	public void close() throws IOException {
		io.close();
		socket.close();
	}

	@Override
	public InputStream getInitialResponseStream() {
		return io.getInitialResponseStream();
	}
}
