/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.expansion;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Optional;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.context.ActiveContext;
import no.hasmac.jsonld.context.TermDefinition;
import no.hasmac.jsonld.expansion.Expansion;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.ListObject;

public final class ArrayExpansion {
    private ActiveContext activeContext;
    private JsonArray element;
    private String activeProperty;
    private URI baseUrl;
    private boolean frameExpansion;
    private boolean ordered;
    private boolean fromMap;

    private ArrayExpansion(ActiveContext activeContext, JsonArray element, String activeProperty, URI baseUrl) {
        this.activeContext = activeContext;
        this.element = element;
        this.activeProperty = activeProperty;
        this.baseUrl = baseUrl;
        this.frameExpansion = false;
        this.ordered = false;
        this.fromMap = false;
    }

    public static ArrayExpansion with(ActiveContext activeContext, JsonArray element, String activeProperty, URI baseUrl) {
        return new ArrayExpansion(activeContext, element, activeProperty, baseUrl);
    }

    public ArrayExpansion frameExpansion(boolean value) {
        this.frameExpansion = value;
        return this;
    }

    public ArrayExpansion ordered(boolean value) {
        this.ordered = value;
        return this;
    }

    public ArrayExpansion fromMap(boolean value) {
        this.fromMap = value;
        return this;
    }

    public JsonArray expand() throws JsonLdError {
        JsonArrayBuilder result = JsonProvider.instance().createArrayBuilder();
        for (JsonValue item : this.element) {
            JsonValue expanded = Expansion.with(this.activeContext, item, this.activeProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).fromMap(this.fromMap).compute();
            Optional<TermDefinition> definition = this.activeContext.getTerm(this.activeProperty);
            if (definition.map(TermDefinition::getContainerMapping).filter(c -> c.contains("@list")).isPresent() && JsonUtils.isArray(expanded)) {
                expanded = ListObject.toListObject(expanded);
            }
            if (JsonUtils.isArray(expanded)) {
                expanded.asJsonArray().stream().filter(JsonUtils::isNotNull).forEach(arg_0 -> ((JsonArrayBuilder)result).add(arg_0));
                continue;
            }
            if (!JsonUtils.isNotNull(expanded)) continue;
            result.add(expanded);
        }
        return result.build();
    }
}

