/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchBulkUpdater;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocument;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentDistance;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentResult;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentScore;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchSpatialSupport;
import org.eclipse.rdf4j.sail.lucene.AbstractSearchIndex;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.eclipse.rdf4j.sail.lucene.DocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.QuerySpec;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.io.GeohashUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="5.3.0", forRemoval=true)
public class ElasticsearchIndex
extends AbstractSearchIndex {
    public static final String INDEX_NAME_KEY = "indexName";
    public static final String DOCUMENT_TYPE_KEY = "documentType";
    public static final String TRANSPORT_KEY = "transport";
    public static final String WAIT_FOR_STATUS_KEY = "waitForStatus";
    public static final String WAIT_FOR_NODES_KEY = "waitForNodes";
    public static final String WAIT_FOR_ACTIVE_SHARDS_KEY = "waitForActiveShards";
    @Deprecated
    public static final String WAIT_FOR_RELOCATING_SHARDS_KEY = "waitForRelocatingShards";
    public static final String WAIT_FOR_NO_RELOCATING_SHARDS_KEY = "waitForNoRelocatingShards";
    public static final String DEFAULT_INDEX_NAME = "elastic-search-sail";
    public static final String DEFAULT_DOCUMENT_TYPE = "resource";
    public static final String DEFAULT_TRANSPORT = "localhost";
    public static final String DEFAULT_ANALYZER = "standard";
    public static final String ELASTICSEARCH_KEY_PREFIX = "elasticsearch.";
    public static final String PROPERTY_FIELD_PREFIX = "p_";
    public static final String ALL_PROPERTY_FIELDS = "p_*";
    public static final String GEOPOINT_FIELD_PREFIX = "_geopoint_";
    public static final String GEOSHAPE_FIELD_PREFIX = "_geoshape_";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile TransportClient client;
    private String clusterName;
    private String indexName;
    private String documentType;
    private String analyzer;
    private String queryAnalyzer = "standard";
    private Function<? super String, ? extends SpatialContext> geoContextMapper;

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String[] getTypes() {
        return new String[]{this.documentType};
    }

    @Override
    public void initialize(Properties parameters) throws Exception {
        String waitForNoRelocatingShards;
        String waitForRelocatingShards;
        String waitForActiveShards;
        super.initialize(parameters);
        this.indexName = parameters.getProperty(INDEX_NAME_KEY, DEFAULT_INDEX_NAME);
        this.documentType = parameters.getProperty(DOCUMENT_TYPE_KEY, DEFAULT_DOCUMENT_TYPE);
        this.analyzer = parameters.getProperty("analyzer", DEFAULT_ANALYZER);
        this.queryAnalyzer = parameters.getProperty("queryAnalyzer", DEFAULT_ANALYZER);
        this.geoContextMapper = this.createSpatialContextMapper(parameters);
        Settings.Builder settingsBuilder = Settings.builder();
        Enumeration<?> iter = parameters.propertyNames();
        while (iter.hasMoreElements()) {
            String[] propName = (String[])iter.nextElement();
            if (!propName.startsWith(ELASTICSEARCH_KEY_PREFIX)) continue;
            String esName = propName.substring(ELASTICSEARCH_KEY_PREFIX.length());
            settingsBuilder.put(esName, parameters.getProperty((String)propName));
        }
        this.client = new PreBuiltTransportClient(settingsBuilder.build(), new Class[0]);
        String transport = parameters.getProperty(TRANSPORT_KEY, DEFAULT_TRANSPORT);
        for (String addrStr : transport.split(",")) {
            if (addrStr.startsWith("local[")) {
                String id = addrStr.substring("local[".length(), addrStr.length() - 1);
                throw new UnsupportedOperationException("Local Transport Address no longer supported");
            }
            String[] hostPort = addrStr.split(":");
            String host = hostPort[0];
            int port = hostPort.length > 1 ? Integer.parseInt(hostPort[1]) : 9300;
            TransportAddress addr = new TransportAddress(InetAddress.getByName(host), port);
            this.client.addTransportAddress(addr);
        }
        this.clusterName = this.client.settings().get("cluster.name");
        boolean exists = ((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.indexName}).execute().actionGet()).isExists();
        if (!exists) {
            this.createIndex();
        }
        this.logger.info("Field mappings:\n{}", this.getMappings());
        ClusterHealthRequestBuilder healthReqBuilder = this.client.admin().cluster().prepareHealth(new String[]{this.indexName});
        String waitForStatus = parameters.getProperty(WAIT_FOR_STATUS_KEY);
        if ("green".equals(waitForStatus)) {
            healthReqBuilder.setWaitForGreenStatus();
        } else if ("yellow".equals(waitForStatus)) {
            healthReqBuilder.setWaitForYellowStatus();
        }
        String waitForNodes = parameters.getProperty(WAIT_FOR_NODES_KEY);
        if (waitForNodes != null) {
            healthReqBuilder.setWaitForNodes(waitForNodes);
        }
        if ((waitForActiveShards = parameters.getProperty(WAIT_FOR_ACTIVE_SHARDS_KEY)) != null) {
            healthReqBuilder.setWaitForActiveShards(Integer.parseInt(waitForActiveShards));
        }
        if ((waitForRelocatingShards = parameters.getProperty(WAIT_FOR_RELOCATING_SHARDS_KEY)) != null) {
            this.logger.warn("Property waitForRelocatingShards no longer supported. Use waitForNoRelocatingShards instead");
        }
        if ((waitForNoRelocatingShards = parameters.getProperty(WAIT_FOR_NO_RELOCATING_SHARDS_KEY)) != null) {
            healthReqBuilder.setWaitForNoRelocatingShards(Boolean.parseBoolean(waitForNoRelocatingShards));
        }
        ClusterHealthResponse healthResponse = (ClusterHealthResponse)healthReqBuilder.execute().actionGet();
        this.logger.info("Cluster health: {}", (Object)healthResponse.getStatus());
        this.logger.info("Cluster nodes: {} (data {})", (Object)healthResponse.getNumberOfNodes(), (Object)healthResponse.getNumberOfDataNodes());
        ClusterIndexHealth indexHealth = (ClusterIndexHealth)healthResponse.getIndices().get(this.indexName);
        this.logger.info("Index health: {}", (Object)indexHealth.getStatus());
        this.logger.info("Index shards: {} (active {} [primary {}], initializing {}, unassigned {}, relocating {})", new Object[]{indexHealth.getNumberOfShards(), indexHealth.getActiveShards(), indexHealth.getActivePrimaryShards(), indexHealth.getInitializingShards(), indexHealth.getUnassignedShards(), indexHealth.getRelocatingShards()});
    }

    protected Function<? super String, ? extends SpatialContext> createSpatialContextMapper(Map<String, String> parameters) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        SpatialContext geoContext = SpatialContextFactory.makeSpatialContext(parameters, (ClassLoader)classLoader);
        return Functions.constant((Object)geoContext);
    }

    public Map<String, Object> getMappings() throws IOException {
        ImmutableOpenMap indexMappings = ((GetMappingsResponse)((GetMappingsRequestBuilder)this.client.admin().indices().prepareGetMappings(new String[]{this.indexName}).setTypes(new String[]{this.documentType})).execute().actionGet()).getMappings();
        ImmutableOpenMap typeMappings = (ImmutableOpenMap)indexMappings.get((Object)this.indexName);
        MappingMetadata mappings = (MappingMetadata)typeMappings.get((Object)this.documentType);
        return mappings.sourceAsMap();
    }

    private void createIndex() throws IOException {
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().field("index.query.default_field", "text").startObject("analysis").startObject("analyzer").startObject("default").field("type", this.analyzer).endObject().endObject().endObject().endObject();){
            ElasticsearchIndex.doAcknowledgedRequest(this.client.admin().indices().prepareCreate(this.indexName).setSettings(Settings.builder().loadFromSource(Strings.toString((XContentBuilder)xContentBuilder), XContentType.JSON)));
        }
        try (XContentBuilder typeMapping = XContentFactory.jsonBuilder();){
            typeMapping.startObject().startObject(this.documentType).startObject("properties");
            typeMapping.startObject("context").field("type", "keyword").field("index", true).field("copy_to", "_all").endObject();
            typeMapping.startObject("uri").field("type", "keyword").field("index", true).field("copy_to", "_all").endObject();
            typeMapping.startObject("text").field("type", "text").field("index", true).field("copy_to", "_all").endObject();
            for (String wktField : this.wktFields) {
                typeMapping.startObject(ElasticsearchIndex.toGeoPointFieldName(wktField)).field("type", "geo_point").endObject();
                if (!this.supportsShapes(wktField)) continue;
                typeMapping.startObject(ElasticsearchIndex.toGeoShapeFieldName(wktField)).field("type", "geo_shape").field("copy_to", "_all").endObject();
            }
            typeMapping.endObject().endObject().endObject();
            ElasticsearchIndex.doAcknowledgedRequest(this.client.admin().indices().preparePutMapping(new String[]{this.indexName}).setType(this.documentType).setSource(typeMapping));
        }
    }

    private boolean supportsShapes(String field) {
        SpatialContext geoContext = (SpatialContext)this.geoContextMapper.apply((Object)field);
        try {
            geoContext.readShapeFromWkt("POLYGON ((0 0, 1 0, 1 1, 0 1, 0 0))");
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    @Override
    protected SpatialContext getSpatialContext(String property) {
        return (SpatialContext)this.geoContextMapper.apply((Object)property);
    }

    @Override
    public void shutDown() throws IOException {
        TransportClient toCloseClient = this.client;
        this.client = null;
        if (toCloseClient != null) {
            toCloseClient.close();
        }
    }

    @Override
    protected SearchDocument getDocument(String id) throws IOException {
        GetResponse response = (GetResponse)this.client.prepareGet(this.indexName, this.documentType, id).execute().actionGet();
        if (response.isExists()) {
            return new ElasticsearchDocument(response.getId(), response.getType(), response.getIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getSource(), this.geoContextMapper);
        }
        return null;
    }

    @Override
    protected Iterable<? extends SearchDocument> getDocuments(String resourceId) throws IOException {
        SearchHits hits = this.getDocuments((QueryBuilder)QueryBuilders.termQuery((String)"uri", (String)resourceId));
        return Iterables.transform((Iterable)hits, hit -> new ElasticsearchDocument((SearchHit)hit, this.geoContextMapper));
    }

    @Override
    protected SearchDocument newDocument(String id, String resourceId, String context) {
        return new ElasticsearchDocument(id, this.documentType, this.indexName, resourceId, context, this.geoContextMapper);
    }

    @Override
    protected SearchDocument copyDocument(SearchDocument doc) {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        Map<String, Object> source = esDoc.getSource();
        HashMap<String, Object> newDocument = new HashMap<String, Object>(source);
        return new ElasticsearchDocument(esDoc.getId(), esDoc.getType(), esDoc.getIndex(), esDoc.getSeqNo(), esDoc.getPrimaryTerm(), newDocument, this.geoContextMapper);
    }

    @Override
    protected void addDocument(SearchDocument doc) throws IOException {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        ElasticsearchIndex.doIndexRequest(this.client.prepareIndex(esDoc.getIndex(), esDoc.getType(), esDoc.getId()).setSource(esDoc.getSource()));
    }

    @Override
    protected void updateDocument(SearchDocument doc) throws IOException {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        ElasticsearchIndex.doUpdateRequest(this.client.prepareUpdate(esDoc.getIndex(), esDoc.getType(), esDoc.getId()).setIfSeqNo(esDoc.getSeqNo()).setIfPrimaryTerm(esDoc.getPrimaryTerm()).setDoc(esDoc.getSource()));
    }

    @Override
    protected void deleteDocument(SearchDocument doc) throws IOException {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        this.client.prepareDelete(esDoc.getIndex(), esDoc.getType(), esDoc.getId()).setIfSeqNo(esDoc.getSeqNo()).setIfPrimaryTerm(esDoc.getPrimaryTerm()).execute().actionGet();
    }

    @Override
    protected BulkUpdater newBulkUpdate() {
        return new ElasticsearchBulkUpdater((Client)this.client);
    }

    private SearchHits getDocuments(QueryBuilder query) throws IOException {
        return this.search(this.client.prepareSearch(new String[0]), query);
    }

    public SearchDocument getDocument(Resource subject, Resource context) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        String contextId = SearchFields.getContextID(context);
        return this.getDocument(SearchFields.formIdString(resourceId, contextId));
    }

    public Iterable<? extends SearchDocument> getDocuments(Resource subject) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        return this.getDocuments(resourceId);
    }

    public static Set<String> getPropertyFields(Set<String> fields) {
        HashSet<String> result = new HashSet<String>(fields.size());
        for (String field : fields) {
            if (!SearchFields.isPropertyField(field)) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public void begin() throws IOException {
    }

    @Override
    public void commit() throws IOException {
        this.client.admin().indices().prepareRefresh(new String[]{this.indexName}).execute().actionGet();
    }

    @Override
    public void rollback() throws IOException {
    }

    @Override
    protected Iterable<? extends DocumentScore> query(Resource subject, QuerySpec spec) throws MalformedQueryException, IOException {
        int numDocs;
        Integer specNumDocs;
        if (spec.getQueryPatterns().size() != 1) {
            throw new IllegalArgumentException("Multi-param query not implemented!");
        }
        QuerySpec.QueryParam param = spec.getQueryPatterns().iterator().next();
        IRI propertyURI = param.getProperty();
        boolean highlight = param.isHighlight();
        String query = param.getQuery();
        QueryStringQueryBuilder qb = this.prepareQuery(propertyURI, QueryBuilders.queryStringQuery((String)query));
        SearchRequestBuilder request = this.client.prepareSearch(new String[0]);
        if (highlight) {
            String field;
            HighlightBuilder hb = new HighlightBuilder();
            if (propertyURI != null) {
                field = ElasticsearchIndex.toPropertyFieldName(SearchFields.getPropertyField(propertyURI));
            } else {
                field = ALL_PROPERTY_FIELDS;
                hb.requireFieldMatch(Boolean.valueOf(false));
            }
            hb.field(field);
            hb.preTags(new String[]{"<B>"});
            hb.postTags(new String[]{"</B>"});
            hb.numOfFragments(Integer.valueOf(0));
            request.highlighter(hb);
        }
        if ((specNumDocs = spec.getNumDocs()) != null) {
            if (specNumDocs < 0) {
                throw new IllegalArgumentException("numDocs must be >= 0");
            }
            numDocs = specNumDocs;
        } else {
            numDocs = -1;
        }
        SearchHits hits = subject != null ? this.search(subject, request, (QueryBuilder)qb, numDocs) : this.search(request, (QueryBuilder)qb, numDocs);
        return Iterables.transform((Iterable)hits, hit -> new ElasticsearchDocumentScore((SearchHit)hit, this.geoContextMapper));
    }

    public SearchHits search(Resource resource, SearchRequestBuilder request, QueryBuilder query) {
        return this.search(resource, request, query, -1);
    }

    public SearchHits search(Resource resource, SearchRequestBuilder request, QueryBuilder query, int numDocs) {
        TermQueryBuilder idQuery = QueryBuilders.termQuery((String)"uri", (String)SearchFields.getResourceID(resource));
        BoolQueryBuilder combinedQuery = QueryBuilders.boolQuery().must((QueryBuilder)idQuery).must(query);
        return this.search(request, (QueryBuilder)combinedQuery, numDocs);
    }

    @Override
    protected Iterable<? extends DocumentDistance> geoQuery(IRI geoProperty, Point p, IRI units, double distance, String distanceVar, Var contextVar) throws MalformedQueryException, IOException {
        double unitDist;
        DistanceUnit unit;
        if (GEOF.UOM_METRE.equals(units)) {
            unit = DistanceUnit.METERS;
            unitDist = distance;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            unit = DistanceUnit.KILOMETERS;
            unitDist = unit.getDistancePerDegree() * distance;
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            unit = DistanceUnit.KILOMETERS;
            unitDist = DistanceUtils.radians2Dist((double)distance, (double)6371.0087714);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            unit = DistanceUnit.KILOMETERS;
            unitDist = distance * Math.PI * 6371.0087714;
        } else {
            throw new MalformedQueryException("Unsupported units: " + String.valueOf(units));
        }
        double lat = p.getY();
        double lon = p.getX();
        String fieldName = ElasticsearchIndex.toGeoPointFieldName(SearchFields.getPropertyField(geoProperty));
        FunctionScoreQueryBuilder qb = QueryBuilders.functionScoreQuery((QueryBuilder)QueryBuilders.geoDistanceQuery((String)fieldName).point(lat, lon).distance(unitDist, unit), (ScoreFunctionBuilder)ScoreFunctionBuilders.linearDecayFunction((String)fieldName, (Object)GeohashUtils.encodeLatLon((double)lat, (double)lon), (Object)new DistanceUnit.Distance(unitDist, unit).toString()));
        if (contextVar != null) {
            qb = this.addContextTerm((QueryBuilder)qb, (Resource)contextVar.getValue());
        }
        SearchRequestBuilder request = this.client.prepareSearch(new String[0]);
        SearchHits hits = this.search(request, (QueryBuilder)qb);
        GeoPoint srcPoint = new GeoPoint(lat, lon);
        return Iterables.transform((Iterable)hits, hit -> new ElasticsearchDocumentDistance((SearchHit)hit, this.geoContextMapper, fieldName, units, srcPoint, unit));
    }

    private QueryBuilder addContextTerm(QueryBuilder qb, Resource ctx) {
        BoolQueryBuilder combinedQuery = QueryBuilders.boolQuery();
        TermQueryBuilder idQuery = QueryBuilders.termQuery((String)"context", (String)SearchFields.getContextID(ctx));
        if (ctx != null) {
            combinedQuery.must((QueryBuilder)idQuery);
        } else {
            combinedQuery.mustNot((QueryBuilder)idQuery);
        }
        combinedQuery.must(qb);
        return combinedQuery;
    }

    @Override
    protected Iterable<? extends DocumentResult> geoRelationQuery(String relation, IRI geoProperty, String wkt, Var contextVar) throws MalformedQueryException, IOException {
        Shape shape = null;
        try {
            shape = super.parseQueryShape(SearchFields.getPropertyField(geoProperty), wkt);
        }
        catch (ParseException e) {
            this.logger.error("error while parsing wkt geometry", (Throwable)e);
        }
        ShapeRelation spatialOp = this.toSpatialOp(relation);
        if (spatialOp == null) {
            return null;
        }
        String fieldName = ElasticsearchIndex.toGeoShapeFieldName(SearchFields.getPropertyField(geoProperty));
        GeoShapeQueryBuilder fb = QueryBuilders.geoShapeQuery((String)fieldName, (ShapeBuilder)ElasticsearchSpatialSupport.getSpatialSupport().toShapeBuilder(shape));
        fb.relation(spatialOp);
        MatchAllQueryBuilder qb = QueryBuilders.matchAllQuery();
        if (contextVar != null) {
            qb = this.addContextTerm((QueryBuilder)qb, (Resource)contextVar.getValue());
        }
        SearchRequestBuilder request = this.client.prepareSearch(new String[0]);
        SearchHits hits = this.search(request, (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)qb).filter((QueryBuilder)fb));
        return Iterables.transform((Iterable)hits, hit -> new ElasticsearchDocumentResult((SearchHit)hit, this.geoContextMapper));
    }

    private ShapeRelation toSpatialOp(String relation) {
        if (GEOF.SF_INTERSECTS.stringValue().equals(relation)) {
            return ShapeRelation.INTERSECTS;
        }
        if (GEOF.SF_DISJOINT.stringValue().equals(relation)) {
            return ShapeRelation.DISJOINT;
        }
        if (GEOF.EH_COVERED_BY.stringValue().equals(relation)) {
            return ShapeRelation.WITHIN;
        }
        return null;
    }

    public SearchHits search(SearchRequestBuilder request, QueryBuilder query) {
        return this.search(request, query, -1);
    }

    public SearchHits search(SearchRequestBuilder request, QueryBuilder query, int numDocs) {
        String[] types = this.getTypes();
        if (numDocs < -1) {
            throw new IllegalArgumentException("numDocs should be 0 or greater if defined by the user");
        }
        int size = this.defaultNumDocs;
        if (numDocs >= 0) {
            size = Math.min(this.maxDocs, numDocs);
        }
        if (size < 0) {
            long docCount = ((SearchResponse)this.client.prepareSearch((String[])new String[]{this.indexName}).setTypes((String[])types).setSource((SearchSourceBuilder)new SearchSourceBuilder().size((int)0).query((QueryBuilder)query)).get()).getHits().getTotalHits().value;
            size = Math.max((int)Math.min(docCount, (long)this.maxDocs), 1);
        }
        SearchResponse response = (SearchResponse)request.setIndices(new String[]{this.indexName}).setTypes(types).setVersion(false).seqNoAndPrimaryTerm(true).setQuery(query).setSize(size).execute().actionGet();
        return response.getHits();
    }

    private QueryStringQueryBuilder prepareQuery(IRI propertyURI, QueryStringQueryBuilder query) {
        if (propertyURI == null) {
            query.defaultField("text").analyzer(this.queryAnalyzer);
        } else {
            query.defaultField(ElasticsearchIndex.toPropertyFieldName(SearchFields.getPropertyField(propertyURI))).analyzer(this.queryAnalyzer);
        }
        return query;
    }

    @Override
    public synchronized void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("deleting contexts: {}", (Object)Arrays.toString(contexts));
        for (Resource context : contexts) {
            String contextString = SearchFields.getContextID(context);
            ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)this.client, (ActionType)DeleteByQueryAction.INSTANCE).source(new String[]{this.indexName})).filter((QueryBuilder)QueryBuilders.termQuery((String)"context", (String)contextString))).get();
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        ElasticsearchIndex.doAcknowledgedRequest(this.client.admin().indices().prepareDelete(new String[]{this.indexName}));
        this.createIndex();
    }

    static String toPropertyFieldName(String prop) {
        return PROPERTY_FIELD_PREFIX + ElasticsearchIndex.encodeFieldName(prop);
    }

    static String toPropertyName(String field) {
        return ElasticsearchIndex.decodeFieldName(field.substring(PROPERTY_FIELD_PREFIX.length()));
    }

    static String toGeoPointFieldName(String prop) {
        return GEOPOINT_FIELD_PREFIX + ElasticsearchIndex.encodeFieldName(prop);
    }

    static String toGeoShapeFieldName(String prop) {
        return GEOSHAPE_FIELD_PREFIX + ElasticsearchIndex.encodeFieldName(prop);
    }

    static String encodeFieldName(String s) {
        return s.replace('.', '^');
    }

    static String decodeFieldName(String s) {
        return s.replace('^', '.');
    }

    private static void doAcknowledgedRequest(ActionRequestBuilder<?, ? extends AcknowledgedResponse> request) throws IOException {
        boolean ok = ((AcknowledgedResponse)request.execute().actionGet()).isAcknowledged();
        if (!ok) {
            throw new IOException("Request not acknowledged: " + ((AcknowledgedResponse)request.get()).getClass().getName());
        }
    }

    private static void doIndexRequest(ActionRequestBuilder<?, ? extends IndexResponse> request) throws IOException {
        IndexResponse response = (IndexResponse)request.execute().actionGet();
        boolean ok = response.status().equals((Object)RestStatus.CREATED);
        if (!ok) {
            throw new IOException("Document not created: " + ((IndexResponse)request.get()).getClass().getName());
        }
    }

    private static void doUpdateRequest(ActionRequestBuilder<?, ? extends UpdateResponse> request) throws IOException {
        UpdateResponse response = (UpdateResponse)request.execute().actionGet();
        boolean isUpsert = response.status().equals((Object)RestStatus.CREATED);
        if (isUpsert) {
            throw new IOException("Unexpected upsert: " + ((UpdateResponse)request.get()).getClass().getName());
        }
    }
}

