/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public class FusePathPlusTailAlternationUnionTransform
extends BaseTransform {
    private FusePathPlusTailAlternationUnionTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            n = n.transformChildren(child -> {
                if (child instanceof IrBGP) {
                    return FusePathPlusTailAlternationUnionTransform.apply((IrBGP)child, r);
                }
                return child;
            });
            if (i + 1 < in.size() && n instanceof IrPathTriple && in.get(i + 1) instanceof IrUnion) {
                IrPathTriple pt = (IrPathTriple)n;
                IrUnion u = (IrUnion)in.get(i + 1);
                if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
                    out.add(n);
                    continue;
                }
                if (!FusePathPlusTailAlternationUnionTransform.isAnonPathVar(pt.getObject())) {
                    out.add(n);
                    continue;
                }
                if (u.getBranches().size() == 2) {
                    BranchTriple b1 = FusePathPlusTailAlternationUnionTransform.getSingleBranchSp(u.getBranches().get(0));
                    BranchTriple b2 = FusePathPlusTailAlternationUnionTransform.getSingleBranchSp(u.getBranches().get(1));
                    if (b1 != null && b2 != null && FusePathPlusTailAlternationUnionTransform.compatibleGraphs(b1.graph, b2.graph)) {
                        Var midVar = pt.getObject();
                        TripleJoin j1 = FusePathPlusTailAlternationUnionTransform.classifyTailJoin(b1, midVar, r);
                        TripleJoin j2 = FusePathPlusTailAlternationUnionTransform.classifyTailJoin(b2, midVar, r);
                        if (j1 != null && j2 != null && j1.iri.equals(j2.iri) && FusePathPlusTailAlternationUnionTransform.sameVar(j1.end, j2.end) && j1.inverse != j2.inverse) {
                            String step = j1.iri;
                            String left = (j1.inverse ? "^" : "") + step;
                            String right = (j2.inverse ? "^" : "") + step;
                            String fusedPath = pt.getPathText() + "/(" + left + "|" + right + ")";
                            IrPathTriple np = new IrPathTriple(pt.getSubject(), fusedPath, j1.end, false, pt.getPathVars());
                            out.add(np);
                            ++i;
                            continue;
                        }
                    }
                }
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    public static boolean compatibleGraphs(Var a, Var b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return FusePathPlusTailAlternationUnionTransform.sameVar(a, b);
    }

    public static TripleJoin classifyTailJoin(BranchTriple bt, Var midVar, TupleExprIRRenderer r) {
        if (bt == null || bt.sp == null) {
            return null;
        }
        Var pv = bt.sp.getPredicate();
        if (!FusePathPlusTailAlternationUnionTransform.isConstantIriPredicate(bt.sp)) {
            return null;
        }
        Var sVar = bt.sp.getSubject();
        Var oVar = bt.sp.getObject();
        if (FusePathPlusTailAlternationUnionTransform.sameVar(midVar, sVar)) {
            return new TripleJoin(FusePathPlusTailAlternationUnionTransform.iri(pv, r), oVar, false);
        }
        if (FusePathPlusTailAlternationUnionTransform.sameVar(midVar, oVar)) {
            return new TripleJoin(FusePathPlusTailAlternationUnionTransform.iri(pv, r), sVar, true);
        }
        return null;
    }

    public static BranchTriple getSingleBranchSp(IrBGP branch) {
        IrGraph g;
        IrBGP inner;
        if (branch == null) {
            return null;
        }
        if (branch.getLines().size() != 1) {
            return null;
        }
        IrNode only = branch.getLines().get(0);
        if (only instanceof IrStatementPattern) {
            return new BranchTriple(null, (IrStatementPattern)only);
        }
        if (only instanceof IrGraph && (inner = (g = (IrGraph)only).getWhere()) != null && inner.getLines().size() == 1 && inner.getLines().get(0) instanceof IrStatementPattern) {
            return new BranchTriple(g.getGraph(), (IrStatementPattern)inner.getLines().get(0));
        }
        return null;
    }

    public static final class BranchTriple {
        public final Var graph;
        public final IrStatementPattern sp;

        BranchTriple(Var graph, IrStatementPattern sp) {
            this.graph = graph;
            this.sp = sp;
        }
    }

    public static final class TripleJoin {
        public final String iri;
        public final Var end;
        public final boolean inverse;

        TripleJoin(String iri, Var end, boolean inverse) {
            this.iri = iri;
            this.end = end;
            this.inverse = inverse;
        }
    }
}

