/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class CanonicalizeUnionBranchOrderTransform
extends BaseTransform {
    private CanonicalizeUnionBranchOrderTransform() {
    }

    public static IrBGP apply(IrBGP bgp, IrSelect select) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrUnion) {
                m = CanonicalizeUnionBranchOrderTransform.reorderUnion((IrUnion)n, select);
            } else if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                m = new IrGraph(g.getGraph(), CanonicalizeUnionBranchOrderTransform.apply(g.getWhere(), select), g.isNewScope());
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(CanonicalizeUnionBranchOrderTransform.apply(o.getWhere(), select), o.isNewScope());
                no.setNewScope(o.isNewScope());
                m = no;
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(CanonicalizeUnionBranchOrderTransform.apply(mi.getWhere(), select), mi.isNewScope());
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                m = new IrService(s.getServiceRefText(), s.isSilent(), CanonicalizeUnionBranchOrderTransform.apply(s.getWhere(), select), s.isNewScope());
            } else if (n instanceof IrSubSelect) {
                // empty if block
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrNode reorderUnion(IrUnion u, IrSelect select) {
        IrUnion u2 = new IrUnion(u.isNewScope());
        for (IrBGP b : u.getBranches()) {
            u2.addBranch(CanonicalizeUnionBranchOrderTransform.apply(b, select));
        }
        return u2;
    }
}

