/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.nio.charset.StandardCharsets;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class EncodeForUri
implements Function {
    @Override
    public String getURI() {
        return FN.ENCODE_FOR_URI.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("ENCODE_FOR_URI requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtility.isStringLiteral(literal)) {
                String lexValue = literal.getLabel();
                return valueFactory.createLiteral(this.encodeUri(lexValue));
            }
            throw new ValueExprEvaluationException("Invalid argument for ENCODE_FOR_URI: " + String.valueOf(literal));
        }
        throw new ValueExprEvaluationException("Invalid argument for ENCODE_FOR_URI: " + String.valueOf(args[0]));
    }

    private String encodeUri(String uri) {
        StringBuilder buf = new StringBuilder(uri.length() * 2);
        int uriLen = uri.length();
        for (int i = 0; i < uriLen; ++i) {
            byte[] utf8;
            char c = uri.charAt(i);
            if (this.isUnreserved(c)) {
                buf.append(c);
                continue;
            }
            for (byte b : utf8 = Character.toString(c).getBytes(StandardCharsets.UTF_8)) {
                buf.append('%');
                char cb = (char)(b & 0xFF);
                String hexVal = Integer.toHexString(cb).toUpperCase();
                if (hexVal.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexVal);
            }
        }
        return buf.toString();
    }

    private boolean isUnreserved(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }
}

