/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class ArbitraryLengthPath
extends AbstractQueryModelNode
implements TupleExpr {
    private StatementPattern.Scope scope;
    private Var subjectVar;
    private TupleExpr pathExpression;
    private Var objectVar;
    private Var contextVar;
    private long minLength;

    public ArbitraryLengthPath() {
    }

    public ArbitraryLengthPath(Var subject, TupleExpr pathExpression, Var object, long minLength) {
        this(StatementPattern.Scope.DEFAULT_CONTEXTS, subject, pathExpression, object, minLength);
    }

    public ArbitraryLengthPath(StatementPattern.Scope scope, Var subject, TupleExpr pathExpression, Var object, long minLength) {
        this(scope, subject, pathExpression, object, null, minLength);
    }

    public ArbitraryLengthPath(Var subject, TupleExpr pathExpression, Var object, Var context, long minLength) {
        this(StatementPattern.Scope.DEFAULT_CONTEXTS, subject, pathExpression, object, context, minLength);
    }

    public ArbitraryLengthPath(StatementPattern.Scope scope, Var subjVar, TupleExpr pathExpression, Var objVar, Var conVar, long minLength) {
        this.setScope(scope);
        this.setSubjectVar(subjVar);
        this.setPathExpression(pathExpression);
        this.setObjectVar(objVar);
        this.setContextVar(conVar);
        this.setMinLength(minLength);
    }

    public StatementPattern.Scope getScope() {
        return this.scope;
    }

    public void setScope(StatementPattern.Scope scope) {
        assert (scope != null) : "scope must not be null";
        this.scope = scope;
    }

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public void setSubjectVar(Var subject) {
        assert (subject != null) : "subject must not be null";
        subject.setParentNode(this);
        this.subjectVar = subject;
    }

    public TupleExpr getPathExpression() {
        return this.pathExpression;
    }

    public void setPathExpression(TupleExpr pathExpression) {
        pathExpression.setParentNode(this);
        this.pathExpression = pathExpression;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public void setObjectVar(Var object) {
        assert (object != null) : "object must not be null";
        object.setParentNode(this);
        this.objectVar = object;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinLength() {
        return this.minLength;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setContextVar(Var context) {
        if (context != null) {
            context.setParentNode(this);
        }
        this.contextVar = context;
    }

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(8);
        if (this.subjectVar != null) {
            bindingNames.add(this.subjectVar.getName());
        }
        if (this.pathExpression != null) {
            bindingNames.addAll(this.pathExpression.getAssuredBindingNames());
        }
        if (this.objectVar != null) {
            bindingNames.add(this.objectVar.getName());
        }
        if (this.contextVar != null) {
            bindingNames.add(this.contextVar.getName());
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.subjectVar != null) {
            this.subjectVar.visit(visitor);
        }
        if (this.pathExpression != null) {
            this.pathExpression.visit(visitor);
        }
        if (this.objectVar != null) {
            this.objectVar.visit(visitor);
        }
        if (this.contextVar != null) {
            this.contextVar.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.subjectVar == current) {
            this.setSubjectVar((Var)replacement);
        } else if (this.pathExpression == current) {
            this.setPathExpression((TupleExpr)replacement);
        } else if (this.objectVar == current) {
            this.setObjectVar((Var)replacement);
        } else if (this.contextVar == current) {
            this.setContextVar((Var)replacement);
        }
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        if (this.scope == StatementPattern.Scope.NAMED_CONTEXTS) {
            sb.append(" FROM NAMED CONTEXT");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ArbitraryLengthPath) {
            ArbitraryLengthPath o = (ArbitraryLengthPath)other;
            return this.subjectVar.equals(o.getSubjectVar()) && this.pathExpression.equals(o.getPathExpression()) && this.objectVar.equals(o.getObjectVar()) && Objects.equals(this.contextVar, o.getContextVar()) && this.scope.equals((Object)o.getScope());
        }
        return false;
    }

    public int hashCode() {
        int result = this.subjectVar.hashCode();
        result ^= this.pathExpression.hashCode();
        result ^= this.objectVar.hashCode();
        if (this.contextVar != null) {
            result ^= this.contextVar.hashCode();
        }
        if (this.scope == StatementPattern.Scope.NAMED_CONTEXTS) {
            result ^= 0xFFFFFFFF;
        }
        return result;
    }

    @Override
    public ArbitraryLengthPath clone() {
        ArbitraryLengthPath clone = (ArbitraryLengthPath)super.clone();
        clone.setSubjectVar(this.getSubjectVar().clone());
        clone.setPathExpression(this.getPathExpression().clone());
        clone.setObjectVar(this.getObjectVar().clone());
        if (this.getContextVar() != null) {
            clone.setContextVar(this.getContextVar().clone());
        }
        return clone;
    }

    @Override
    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        return Set.of();
    }

    @Override
    public void setOrder(Var var) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Var getOrder() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

