/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrTripleLike;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.SimplifyPathParensTransform;
import org.eclipse.rdf4j.queryrender.sparql.util.VarUtils;

public class IrPathTriple
extends IrTripleLike {
    private final String pathText;
    private Set<Var> pathVars;

    public IrPathTriple(Var subject, String pathText, Var object, boolean newScope, Set<Var> pathVars) {
        this(subject, null, pathText, object, null, pathVars, newScope);
    }

    public IrPathTriple(Var subject, IrNode subjectOverride, String pathText, Var object, IrNode objectOverride, Set<Var> pathVars, boolean newScope) {
        super(subject, subjectOverride, object, objectOverride, newScope);
        this.pathText = pathText;
        this.pathVars = Set.copyOf(pathVars);
    }

    public String getPathText() {
        return this.pathText;
    }

    @Override
    public String getPredicateOrPathText(TupleExprIRRenderer r) {
        return this.pathText;
    }

    public Set<Var> getPathVars() {
        return this.pathVars;
    }

    public void setPathVars(Set<Var> vars) {
        this.pathVars = vars.isEmpty() ? Collections.emptySet() : Set.copyOf(vars);
    }

    public static Set<Var> mergePathVars(IrPathTriple ... pts) {
        if (pts == null || pts.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Var> out = new HashSet<Var>();
        for (IrPathTriple pt : pts) {
            if (pt == null || pt.getPathVars() == null) continue;
            out.addAll(pt.getPathVars());
        }
        return out.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(out);
    }

    public static Set<Var> fromStatementPatterns(IrStatementPattern ... sps) {
        if (sps == null || sps.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Var> out = new HashSet<Var>();
        for (IrStatementPattern sp : sps) {
            if (sp == null) continue;
            Var s = sp.getSubject();
            Var o = sp.getObject();
            Var p = sp.getPredicate();
            if (IrPathTriple.isAnonBridgeVar(s)) {
                out.add(s);
            }
            if (IrPathTriple.isAnonBridgeVar(o)) {
                out.add(o);
            }
            if (!IrPathTriple.isAnonBridgeVar(p)) continue;
            out.add(p);
        }
        return out.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(out);
    }

    private static boolean isAnonBridgeVar(Var v) {
        return VarUtils.isAnonPathVar(v) || VarUtils.isAnonPathInverseVar(v);
    }

    @Override
    public void print(IrPrinter p) {
        p.startLine();
        if (this.getSubjectOverride() != null) {
            this.getSubjectOverride().print(p);
        } else {
            p.append(p.convertVarToString(this.getSubject()));
        }
        String simplified = SimplifyPathParensTransform.simplify(this.pathText);
        p.append(" " + simplified + " ");
        if (this.getObjectOverride() != null) {
            this.getObjectOverride().print(p);
        } else {
            p.append(p.convertVarToString(this.getObject()));
        }
        p.append(" .");
        p.endLine();
    }

    public String toString() {
        return "IrPathTriple{pathText='" + this.pathText + "', pathVars=" + Arrays.toString(this.pathVars.toArray()) + ", subject=" + String.valueOf(this.subject) + ", subjectOverride=" + String.valueOf(this.subjectOverride) + ", object=" + String.valueOf(this.object) + ", objectOverride=" + String.valueOf(this.objectOverride) + "}";
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> out = new HashSet<Var>(super.getVars());
        if (this.pathVars != null) {
            out.addAll(this.pathVars);
        }
        return out;
    }
}

