/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MultiReleaseMemCopy {
    private MultiReleaseMemCopy() {
    }

    static void copy(long src, long dst, long bytes) {
        if (Pointer.BITS64 && bytes <= 160L && ((src | dst) & 7L) == 0L) {
            MemoryUtil.memCopyAligned64(src, dst, (int)bytes & 0xFF);
            return;
        }
        MemoryUtil.UNSAFE.copyMemory(null, src, null, dst, bytes);
    }

    static {
        APIUtil.apiLog("Java 17 memcpy enabled");
    }
}

