/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableBooleanBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanSingletonBag;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;

public enum ImmutableBooleanBagFactoryImpl implements ImmutableBooleanBagFactory
{
    INSTANCE;


    public ImmutableBooleanBag empty() {
        return ImmutableBooleanEmptyBag.INSTANCE;
    }

    public ImmutableBooleanBag of() {
        return this.empty();
    }

    public ImmutableBooleanBag with() {
        return this.empty();
    }

    public ImmutableBooleanBag of(boolean one) {
        return this.with(one);
    }

    public ImmutableBooleanBag with(boolean one) {
        return new ImmutableBooleanSingletonBag(one);
    }

    public ImmutableBooleanBag of(boolean ... items) {
        return this.with(items);
    }

    public ImmutableBooleanBag with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableBooleanHashBag.newBagWith(items);
    }

    public ImmutableBooleanBag ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public ImmutableBooleanBag withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanBag) {
            return (ImmutableBooleanBag)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableBooleanBag ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableBooleanBag withAll(Iterable<Boolean> iterable) {
        return BooleanBags.mutable.withAll(iterable).toImmutable();
    }
}

