/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.rename.RenameTagProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameTagWizard
extends RefactoringWizard {
    public RenameTagWizard(Tag tag) {
        super((Refactoring)new RenameRefactoring((RenameProcessor)new RenameTagProcessor(tag)), 4);
        this.setDefaultPageTitle(Messages.RenameTagWizard_PageTitle);
        this.setWindowTitle(Messages.RenameTagWizard_WindowTitle);
    }

    protected void addUserInputPages() {
        RenameTagProcessor processor = (RenameTagProcessor)((Object)this.getRefactoring().getAdapter(RenameTagProcessor.class));
        this.addPage((IWizardPage)new RenameTagPage(processor));
    }

    private static final class RenameTagPage
    extends UserInputWizardPage {
        private final RenameTagProcessor processor;
        private Text nameText;

        public RenameTagPage(RenameTagProcessor processor) {
            super("RenameTagRefactoringInputPage");
            this.processor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout((Layout)gridLayout);
            this.setControl((Control)composite);
            Label label = new Label(composite, 16384);
            label.setText(Messages.RenameTagWizard_NewNameLabel);
            this.nameText = new Text(composite, 2048);
            GridData data = new GridData(768);
            this.nameText.setLayoutData((Object)data);
            this.nameText.setText(this.processor.getTag().getValue());
            this.setPageComplete(false);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.validatePage();
                }
            });
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.nameText.selectAll();
                this.nameText.forceFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text = this.nameText.getText();
            RefactoringStatus status = this.processor.validateNewTagName(text);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            this.processor.setNewTagName(this.nameText.getText());
        }
    }
}

