/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOverviewPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SchemaSpecSection
extends PDESection {
    private FormEntry fPluginText;
    private FormEntry fPointText;
    private FormEntry fNameText;

    public SchemaSpecSection(SchemaOverviewPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEUIMessages.SchemaEditor_SpecSection_title);
        this.getSection().setDescription(PDEUIMessages.SchemaEditor_SpecSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.fPluginText.commit();
        this.fPointText.commit();
        this.fNameText.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fPluginText.cancelEdit();
        this.fPointText.cancelEdit();
        this.fNameText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        final Schema schema = (Schema)this.getPage().getModel();
        this.fPluginText = new FormEntry(container, toolkit, PDEUIMessages.SchemaEditor_SpecSection_plugin, null, false);
        this.fPluginText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                schema.setPluginId(text.getValue());
            }
        });
        this.fPointText = new FormEntry(container, toolkit, PDEUIMessages.SchemaEditor_SpecSection_point, null, false);
        this.fPointText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                schema.setPointId(text.getValue());
            }
        });
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.SchemaEditor_SpecSection_name, null, false);
        this.fNameText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                schema.setName(text.getValue());
                SchemaSpecSection.this.getPage().getManagedForm().getForm().setText(schema.getName());
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    public void dispose() {
        ISchema schema = (ISchema)this.getPage().getModel();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        ISchema schema = (ISchema)this.getPage().getModel();
        this.refresh();
        this.fPluginText.setEditable(this.isEditable());
        this.fPointText.setEditable(this.isEditable());
        this.fNameText.setEditable(this.isEditable());
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void setFocus() {
        if (this.fPluginText != null) {
            this.fPluginText.getText().setFocus();
        }
    }

    public void refresh() {
        ISchema schema = (ISchema)this.getPage().getModel();
        this.fPluginText.setValue(schema.getPluginId(), true);
        this.fPointText.setValue(schema.getPointId(), true);
        this.fNameText.setValue(schema.getName(), true);
        this.getPage().getManagedForm().getForm().setText(schema.getName());
        super.refresh();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        return this.isEditable();
    }
}

