/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.debug.core.Debugger;
import org.eclipse.rcptt.ecl.debug.core.DebuggerCallback;
import org.eclipse.rcptt.ecl.debug.core.DebuggerTransport;
import org.eclipse.rcptt.ecl.debug.core.NullDebuggerTransport;
import org.eclipse.rcptt.ecl.debug.model.DebugType;
import org.eclipse.rcptt.ecl.debug.model.Event;
import org.eclipse.rcptt.ecl.debug.model.ResolveVariableEvent;
import org.eclipse.rcptt.ecl.debug.model.StackEvent;
import org.eclipse.rcptt.ecl.debug.model.StackFrame;
import org.eclipse.rcptt.ecl.debug.model.Variable;
import org.eclipse.rcptt.ecl.debug.runtime.ModelUtils;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugElement;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugThread;
import org.eclipse.rcptt.ecl.internal.debug.core.EclStackFrame;
import org.eclipse.rcptt.ecl.internal.debug.core.EclValue;
import org.eclipse.rcptt.ecl.internal.debug.core.Plugin;

public class EclDebugTarget
extends EclDebugElement
implements IDebugTarget,
IBreakpointManagerListener,
Debugger,
DebuggerCallback {
    private final IProcess process;
    private final EclDebugThread thread;
    private final IThread[] threads;
    private volatile DebuggerTransport transport;
    private volatile IStackFrame[] frames = new IStackFrame[0];
    private volatile boolean suspended = true;
    private volatile boolean stepping = false;
    private volatile AtomicBoolean initialized = new AtomicBoolean();
    private Map<String, IValue> resolveRequests = new HashMap<String, IValue>();

    public EclDebugTarget(IProcess process) throws CoreException {
        this.process = process;
        this.thread = new EclDebugThread(this);
        this.threads = new IThread[]{this.thread};
    }

    @Override
    public void setTransport(DebuggerTransport transport) {
        if (transport == null) {
            transport = new NullDebuggerTransport();
        }
        if (this.transport != null) {
            this.transport.setCallback(null);
        }
        this.transport = transport;
        transport.setCallback(this);
    }

    @Override
    public ILaunch getLaunch() {
        return this.process.getLaunch();
    }

    public IProcess getProcess() {
        return this.process;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public IStackFrame[] getFrames() {
        return this.frames;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getName() throws DebugException {
        ILaunchConfiguration configuration = this.getLaunch().getLaunchConfiguration();
        return configuration != null ? configuration.getName() : "Unknown";
    }

    public boolean canTerminate() {
        return this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.getProcess().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.process.canTerminate()) {
            this.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            this.getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
            this.frames = new IStackFrame[0];
            this.process.terminate();
            this.fireTerminateEvent();
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public void suspend() {
        this.request((EObject)ModelUtils.createDebugCmd((DebugType)DebugType.SUSPEND));
    }

    public void resume() {
        this.request((EObject)ModelUtils.createDebugCmd((DebugType)DebugType.RESUME));
    }

    public void step() {
        this.stepStarted();
        this.request((EObject)ModelUtils.createDebugCmd((DebugType)DebugType.STEP));
    }

    public void stepOver() {
        this.stepOverStarted();
        this.request((EObject)ModelUtils.createDebugCmd((DebugType)DebugType.STEP_OVER));
    }

    public void stepReturn() {
        this.stepReturnStarted();
        this.request((EObject)ModelUtils.createDebugCmd((DebugType)DebugType.STEP_RETURN));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            if (this.supportsBreakpoint(breakpoint) && breakpoint.isEnabled()) {
                int line = ((ILineBreakpoint)breakpoint).getLineNumber();
                String path = breakpoint.getMarker().getResource().getFullPath().toString();
                this.request((EObject)ModelUtils.createBreakpointCmd((DebugType)DebugType.BREAKPOINT_ADD, (String)path, (int)line));
            }
        }
        catch (CoreException e) {
            Plugin.log(e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                int line = ((ILineBreakpoint)breakpoint).getLineNumber();
                String path = breakpoint.getMarker().getResource().getFullPath().toString();
                this.request((EObject)ModelUtils.createBreakpointCmd((DebugType)DebugType.BREAKPOINT_REMOVE, (String)path, (int)line));
            }
            catch (CoreException e) {
                Plugin.log(e);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException e) {
                Plugin.log(e);
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.request((EObject)ModelUtils.createSkipAllEvent((!enabled ? 1 : 0) != 0));
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!breakpoint.getModelIdentifier().equals("org.eclipse.rcptt.ecl.debug.core")) return false;
        try {
            IMarker marker = breakpoint.getMarker();
            if (marker == null) return false;
            IResource[] resources = this.getLaunch().getLaunchConfiguration().getMappedResources();
            if (resources == null) return false;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (marker.getResource().equals((Object)resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Plugin.log(e);
        }
        return false;
    }

    private IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    private void request(EObject event) {
        try {
            this.transport.request(event);
        }
        catch (CoreException e) {
            Plugin.log(e.getMessage(), e);
        }
    }

    @Override
    public void handleResponse(EObject event) {
        this.thread.setBreakpoints(null);
        if (!(event instanceof Event)) {
            return;
        }
        switch (((Event)event).getType()) {
            case STARTED: {
                this.started();
                break;
            }
            case SUSPENDED: {
                this.suspended((StackEvent)event);
                break;
            }
            case STEP_ENDED: {
                this.stepEnded((StackEvent)event);
                break;
            }
            case BREAKPOINT_HIT: {
                this.breakpointHit((StackEvent)event);
                break;
            }
            case RESUMED: {
                this.resumed();
                break;
            }
            case RESOLVE_VARIABLE: {
                this.variableResolved((ResolveVariableEvent)event);
            }
        }
    }

    private void started() {
        if (this.initialized.compareAndSet(false, true)) {
            this.getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
            this.getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            this.fireCreationEvent();
        }
        this.installDeferredBreakpoints();
        if (!this.getBreakpointManager().isEnabled()) {
            this.request((EObject)ModelUtils.createSkipAllEvent((boolean)true));
        }
        if (this.isStepping()) {
            this.request((EObject)ModelUtils.createDebugCmd((DebugType)DebugType.STEP));
        } else {
            this.resume();
        }
    }

    private void suspended(StackEvent event) {
        this.suspended(event, 32);
    }

    private void resumed() {
        this.suspended = false;
        this.frames = new IStackFrame[0];
        this.thread.fireResumeEvent(32);
    }

    private void stepStarted() {
        this.stepping = true;
        this.thread.fireResumeEvent(1);
    }

    private void stepOverStarted() {
        this.stepping = true;
        this.thread.fireResumeEvent(2);
    }

    private void stepReturnStarted() {
        this.stepping = true;
        this.thread.fireResumeEvent(4);
    }

    private void stepEnded(StackEvent event) {
        this.suspended(event, 8);
    }

    private void breakpointHit(StackEvent event) {
        StackFrame data = (StackFrame)event.getStackFrame().get(0);
        IBreakpoint breakpoint = this.getBreakpoint(data);
        if (breakpoint != null && this.supportsBreakpoint(breakpoint)) {
            this.thread.setBreakpoints(new IBreakpoint[]{breakpoint});
        }
        this.suspended(event, 16);
    }

    private IBreakpoint getBreakpoint(StackFrame frame) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.rcptt.ecl.debug.core");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof ILineBreakpoint) {
                ILineBreakpoint lb = (ILineBreakpoint)breakpoint;
                try {
                    IPath bp = breakpoint.getMarker().getResource().getFullPath();
                    Path sp = new Path(frame.getFile());
                    if (lb.getLineNumber() == frame.getLine() && sp.equals((Object)bp)) {
                        return breakpoint;
                    }
                }
                catch (CoreException e) {
                    Plugin.log(e);
                }
            }
            ++i;
        }
        return null;
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.rcptt.ecl.debug.core");
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    private void suspended(StackEvent event, int details) {
        this.suspended = true;
        this.stepping = false;
        this.updateStack(event);
        this.thread.fireSuspendEvent(details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStack(StackEvent event) {
        Map<String, IValue> map = this.resolveRequests;
        synchronized (map) {
            this.resolveRequests.clear();
        }
        EList eventFrames = event.getStackFrame();
        IStackFrame[] newFrames = new IStackFrame[eventFrames.size()];
        int i = 0;
        while (i < eventFrames.size()) {
            newFrames[i] = new EclStackFrame(this.thread, (StackFrame)eventFrames.get(i));
            ++i;
        }
        this.frames = newFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveVariable(Variable arg, EclValue eclValue) {
        Map<String, IValue> map = this.resolveRequests;
        synchronized (map) {
            this.resolveRequests.put(arg.getId(), eclValue);
        }
        this.request((EObject)ModelUtils.createVariableCmd((String)arg.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void variableResolved(ResolveVariableEvent event) {
        EclValue value = null;
        Variable var = event.getVariable();
        if (var == null) {
            return;
        }
        Map<String, IValue> map = this.resolveRequests;
        synchronized (map) {
            value = (EclValue)this.resolveRequests.get(var.getId());
            this.resolveRequests.remove(var.getId());
        }
        if (value != null) {
            value.setVariable(var);
            DebugEvent de = new DebugEvent((Object)value, 528);
            this.fireEvent(de);
        }
    }
}

