/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaMethodHandlerFactory {
    private static int FAILURE_COUNT_TOLERANCE = 5;
    private final Object fInvalid;

    JavaMethodHandlerFactory(OCLStandardLibrary<EClassifier> oclStdLib) {
        this.fInvalid = oclStdLib.getInvalid();
    }

    CallHandler createHandler(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        Operation opAnnotation = method.getAnnotation(Operation.class);
        return new Handler(method, opAnnotation != null && opAnnotation.contextual(), opAnnotation != null && opAnnotation.withExecutionContext());
    }

    private Object getInvalidResult() {
        return this.fInvalid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Handler
    extends CallHandler {
        private final Method fMethod;
        private final Class<?>[] fCachedParamTypes;
        private final boolean fIsContextual;
        private final boolean fWithExecutionContext;
        private final boolean fRequiresNumConversion;
        private volatile int fFatalErrorCount;

        Handler(Method method, boolean isContextual, boolean isWithExecutionContext) {
            assert (method != null);
            this.fMethod = method;
            this.fCachedParamTypes = this.fMethod.getParameterTypes();
            this.fIsContextual = isContextual;
            this.fWithExecutionContext = isWithExecutionContext;
            this.fRequiresNumConversion = this.requiresNumberConversion();
            this.fFatalErrorCount = 0;
        }

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            try {
                if (this.isDisabled()) {
                    return JavaMethodHandlerFactory.this.getInvalidResult();
                }
                Object[] actualArgs = this.prepareArguments(source, args, evalEnv);
                Object javaCallSource = null;
                boolean isStatic = Modifier.isStatic(this.fMethod.getModifiers());
                if (!isStatic) {
                    Class<?> moduleJavaClass = this.fMethod.getDeclaringClass();
                    javaCallSource = this.getJavaCallSource(module, moduleJavaClass, evalEnv);
                    assert (javaCallSource != null);
                }
                return this.fMethod.invoke(javaCallSource, actualArgs);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof OperationCanceledException) {
                    throw new QvtInterruptedExecutionException();
                }
                this.incrementFatalErrorCount();
                QvtPlugin.error(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod), t);
                String localized = "\nCaused by: " + t.getClass().getName() + (t.getLocalizedMessage() == null ? "" : ": " + t.getLocalizedMessage());
                evalEnv.getAdapter(InternalEvaluationEnv.class).throwQVTException(new QvtRuntimeException(String.valueOf(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod)) + localized, t));
                return CallHandlerAdapter.getInvalidResult(evalEnv);
            }
        }

        private void incrementFatalErrorCount() {
            ++this.fFatalErrorCount;
        }

        private Object getJavaCallSource(ModuleInstance moduleInstance, Class<?> javaClass, QvtOperationalEvaluationEnv evalEnv) throws IllegalAccessException, InstantiationException {
            Object callSource = moduleInstance.getAdapter(javaClass);
            if (callSource != null) {
                return callSource;
            }
            TransformationInstance rootTransformation = evalEnv.getRoot().getAdapter(InternalEvaluationEnv.class).getCurrentTransformation();
            callSource = rootTransformation.getAdapter(javaClass);
            if (callSource == null) {
                callSource = javaClass.newInstance();
                rootTransformation.getAdapter(ModuleInstance.Internal.class).addAdapter(callSource);
            }
            moduleInstance.getAdapter(ModuleInstance.Internal.class).addAdapter(callSource);
            return callSource;
        }

        private boolean isDisabled() {
            return this.fFatalErrorCount > FAILURE_COUNT_TOLERANCE;
        }

        private Object[] prepareArguments(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            int argCount = args.length;
            if (this.fIsContextual) {
                ++argCount;
            }
            if (this.fWithExecutionContext) {
                ++argCount;
            }
            Object[] resultArgs = new Object[argCount];
            int argIndex = 0;
            if (this.fWithExecutionContext) {
                resultArgs[argIndex] = evalEnv.getContext();
                ++argIndex;
            }
            if (this.fIsContextual) {
                resultArgs[argIndex] = source;
                ++argIndex;
            }
            int i = 0;
            while (i < args.length) {
                Object nextArg = args[i];
                if (nextArg == JavaMethodHandlerFactory.this.getInvalidResult()) {
                    nextArg = null;
                }
                if (this.fRequiresNumConversion) {
                    nextArg = NumberConversions.convertNumber(nextArg, this.fCachedParamTypes[argIndex]);
                }
                resultArgs[argIndex++] = nextArg;
                ++i;
            }
            return resultArgs;
        }

        private boolean requiresNumberConversion() {
            assert (this.fMethod != null);
            Class<?>[] classArray = this.fMethod.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paramType = classArray[n2];
                if (Number.class.isAssignableFrom(paramType)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

