/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core.nestedElements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transformation {
    private String transformationPath;
    private Map inModels = new HashMap();
    private Map outModels = new HashMap();
    private List modelsNotPreloaded = new ArrayList();

    public Transformation(String transformationPath) {
        this.transformationPath = transformationPath;
    }

    public void addInModel(String modelNameInTransformationHeader, String globalModelName) {
        this.inModels.put(modelNameInTransformationHeader, globalModelName);
    }

    public void addInNotPreloadedList(String modelName) {
        this.modelsNotPreloaded.add(modelName);
    }

    public void addOutModel(String modelNameInConfiguration, String modelName, String metamodelName) {
        this.outModels.put(modelNameInConfiguration, new OutModel(modelName, metamodelName));
    }

    public String getTransformationPath() {
        return this.transformationPath;
    }

    public Map getInModels() {
        return this.inModels;
    }

    public Map getOutModels() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String modelNameInConfiguration : this.outModels.keySet()) {
            ret.put(modelNameInConfiguration, ((OutModel)this.outModels.get(modelNameInConfiguration)).globalModelName);
        }
        return ret;
    }

    public Map getOutModelsForLoading() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String modelNameInConfiguration : this.outModels.keySet()) {
            ret.put(((OutModel)this.outModels.get(modelNameInConfiguration)).globalModelName, ((OutModel)this.outModels.get(modelNameInConfiguration)).globalMetamodelName);
        }
        return ret;
    }

    public List getModelsNotPreloaded() {
        return this.modelsNotPreloaded;
    }

    private class OutModel {
        private String globalModelName;
        private String globalMetamodelName;

        public OutModel(String modelName, String metamodelName) {
            this.globalModelName = modelName;
            this.globalMetamodelName = metamodelName;
        }
    }
}

