/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.engine.AtlNbCharFile;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class MarkerMaker {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static Map severities = new HashMap();

    static {
        severities.put("error", new Integer(2));
        severities.put("warning", new Integer(1));
        severities.put("critic", new Integer(0));
    }

    private void eObjectToPbmMarker(IResource res, EObject problem, int tabWidth) {
        EPackage pkProblem = null;
        EClass clProblem = null;
        EStructuralFeature sfSeverity = null;
        EStructuralFeature sfLocation = null;
        EStructuralFeature sfDescription = null;
        pkProblem = problem.eClass().getEPackage();
        clProblem = (EClass)pkProblem.getEClassifier("Problem");
        sfSeverity = clProblem.getEStructuralFeature("severity");
        sfLocation = clProblem.getEStructuralFeature("location");
        sfDescription = clProblem.getEStructuralFeature("description");
        String description = (String)problem.eGet(sfDescription);
        String location = (String)problem.eGet(sfLocation);
        int lineNumber = Integer.parseInt(location.split(":")[0]);
        int charStart = 0;
        int charEnd = 0;
        try {
            AtlNbCharFile help = new AtlNbCharFile(((IFile)res).getContents());
            if (location.indexOf(45) == -1) {
                location = String.valueOf(location) + '-' + location;
            }
            int[] pos = help.getIndexChar(location, tabWidth);
            charStart = pos[0];
            charEnd = pos[1];
        }
        catch (CoreException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
        String severity = ((EEnumLiteral)problem.eGet(sfSeverity)).getName();
        int eclipseSeverity = (Integer)severities.get(severity);
        try {
            IMarker pbmMarker = res.createMarker("org.eclipse.core.resources.problemmarker");
            pbmMarker.setAttribute("severity", eclipseSeverity);
            pbmMarker.setAttribute("message", (Object)description);
            pbmMarker.setAttribute("lineNumber", lineNumber);
            pbmMarker.setAttribute("charStart", charStart);
            pbmMarker.setAttribute("charEnd", charEnd > charStart ? charEnd : charStart + 1);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private void createPbmMarkers(IResource res, EObject[] eos, int tabWidth) {
        int i = 0;
        while (i < eos.length) {
            this.eObjectToPbmMarker(res, eos[i], tabWidth);
            ++i;
        }
    }

    public void resetPbmMarkers(IResource res, EObject[] eos) throws CoreException {
        this.resetPbmMarkers(res, eos, -1);
    }

    public void resetPbmMarkers(final IResource res, final EObject[] eos, final int tabWidth) throws CoreException {
        try {
            res.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MarkerMaker.this.createPbmMarkers(res, eos, tabWidth);
            }
        };
        res.getWorkspace().run(r, null, 1, null);
    }

    public int applyMarkers(IFile file, ASMModel pbs) throws CoreException {
        return this.applyMarkers(file, pbs, -1);
    }

    public int applyMarkers(IFile file, ASMModel pbs, int tabWidth) throws CoreException {
        int nbErrors = 0;
        Set pbsc = pbs.getElementsByType("Problem");
        EObject[] pbsa = new EObject[pbsc.size()];
        int k = 0;
        Iterator i = pbsc.iterator();
        while (i.hasNext()) {
            ASMEMFModelElement ame = (ASMEMFModelElement)i.next();
            pbsa[k] = ame.getObject();
            if ("error".equals(((ASMEnumLiteral)ame.get(null, "severity")).getName())) {
                ++nbErrors;
            }
            ++k;
        }
        this.resetPbmMarkers((IResource)file, pbsa, tabWidth);
        return nbErrors;
    }
}

