/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.inputcontent.internal;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFInputContentPapyrusReferenceDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.MultipleEditableReferenceLifecycleManager;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.PapyrusEEFExtEObjectCreationWizard;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.inputcontent.internal.InputContentExpressionContentProvider;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.widgets.Composite;

public class InputContentPapyrusReferenceLifecycleManager
extends MultipleEditableReferenceLifecycleManager {
    private static final String EMPTY_STRING = "";

    public InputContentPapyrusReferenceLifecycleManager(EEFInputContentPapyrusReferenceDescription description, EObject target, EReference eReference, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super((EEFExtEditableReferenceDescription)description, target, eReference, variableManager, interpreter, editingContextAdapter);
    }

    @Override
    protected void createTable(Composite parent) {
        super.createTable(parent);
        String inputContentExpression = this.getInputContentExpression();
        if (!inputContentExpression.isEmpty()) {
            this.tableViewer.setContentProvider((IContentProvider)new InputContentExpressionContentProvider(inputContentExpression, this.interpreter, this.variableManager));
        }
    }

    private String getInputContentExpression() {
        return Optional.ofNullable(this.getWidgetDescription().getInputContentExpression()).orElse(EMPTY_STRING);
    }

    protected EEFInputContentPapyrusReferenceDescription getWidgetDescription() {
        return (EEFInputContentPapyrusReferenceDescription)this.description;
    }

    @Override
    protected void addButtonCallback() {
        List types = this.getController().getPropertiesUtils().getAllPossibleTypes(this.composedAdapterFactory, this.editingContextAdapter, this.target, this.eReference);
        int returnCode = 1;
        EObject objectCreated = null;
        String inputContentExpression = this.getInputContentExpression();
        if (types.size() == 1 && this.eReference.isContainment() && inputContentExpression.isEmpty()) {
            objectCreated = this.createUmlElement(this.target, (EStructuralFeature)this.eReference, ((EObject)types.get(0)).eClass().getName());
            if (objectCreated != null) {
                returnCode = this.getController().getPropertiesUtils().displayCreationProperties(this.editingContextAdapter, objectCreated, this.variableManager, this.interpreter);
            }
        } else {
            PapyrusEEFExtEObjectCreationWizard wizard = new PapyrusEEFExtEObjectCreationWizard(this.target, this.eReference, this.editingContextAdapter);
            wizard.setWindowTitle("Create a new UML Element");
            WizardDialog wizardDialog = new WizardDialog(this.tableViewer.getTable().getShell(), (IWizard)wizard);
            returnCode = wizardDialog.open();
            if (returnCode != 0) {
                throw new OperationCanceledException();
            }
            objectCreated = this.createUmlElement(wizard.getSelectedEContainer(), wizard.getSelectedEContainerFeature(), wizard.getSelectedTypeName());
            if (objectCreated != null) {
                returnCode = this.getController().getPropertiesUtils().displayCreationProperties(this.editingContextAdapter, objectCreated, this.variableManager, this.interpreter);
                if (returnCode != 0) {
                    throw new OperationCanceledException();
                }
                if (!this.eReference.isContainment() || !inputContentExpression.isEmpty()) {
                    this.updateTargetReference(objectCreated, false);
                }
            }
        }
        if (returnCode != 0) {
            throw new OperationCanceledException();
        }
        this.refresh();
        this.tableViewer.getTable().deselectAll();
        this.setEnabled(this.isEnabled());
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        String createExpression = Optional.ofNullable(this.getWidgetDescription().getCreateExpression()).orElse(EMPTY_STRING);
        String browseExpression = Optional.ofNullable(this.getWidgetDescription().getBrowseExpression()).orElse(EMPTY_STRING);
        String removeExpression = Optional.ofNullable(this.getWidgetDescription().getRemoveExpression()).orElse(EMPTY_STRING);
        if (this.addButton != null && !this.addButton.isDisposed() && createExpression.isBlank()) {
            this.addButton.setEnabled(false);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed() && browseExpression.isBlank()) {
            this.browseButton.setEnabled(false);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed() && removeExpression.isBlank()) {
            this.removeButton.setEnabled(false);
        }
    }
}

