/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.menu.listener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.DefaultNavigationMenu;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.NavigationSubMenuButton;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.listener.NavigationMenuKeyListener;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.listener.SelectionMenuSelectionChangedListener;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.provider.SelectionMenuLabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.SelectionMenu;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectionMenuMouseTrackListener
implements MouseTrackListener {
    private Object previousData;
    private DefaultNavigationMenu navigationMenu;
    private SelectionMenu selectionMenu;
    private List<SelectionMenu> subMenus;
    private Object umlElement;

    public SelectionMenuMouseTrackListener(DefaultNavigationMenu navigationMenu, SelectionMenu selectionMenu, List<SelectionMenu> subMenus, Object umlElement) {
        this.navigationMenu = navigationMenu;
        this.selectionMenu = selectionMenu;
        this.subMenus = subMenus;
        this.umlElement = umlElement;
        this.previousData = null;
    }

    public void mouseEnter(MouseEvent e) {
        this.openSubMenu(e);
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        this.openSubMenu(e);
    }

    private Object getData(MouseEvent e) {
        TableItem item;
        if (e.getSource() instanceof Table && (item = ((Table)e.getSource()).getItem(new Point(e.x, e.y))) != null) {
            return item.getData();
        }
        return null;
    }

    private void openSubMenu(MouseEvent event) {
        Object hoveredItem = this.getData(event);
        Point cursorPosition = new Point(event.x, event.y);
        if (hoveredItem != null && hoveredItem != this.previousData && event.getSource() instanceof Table) {
            this.previousData = hoveredItem;
            if (this.subMenus != null) {
                Shell levelShell = ((Table)event.getSource()).getShell();
                ArrayList<SelectionMenu> subMenusToDelete = new ArrayList<SelectionMenu>();
                for (SelectionMenu subMenu : this.subMenus) {
                    if (!subMenu.getParentShell().equals(levelShell)) continue;
                    subMenusToDelete.add(subMenu);
                    subMenu.dispose();
                }
                this.subMenus.removeAll(subMenusToDelete);
            }
            if (hoveredItem instanceof NavigationSubMenuButton) {
                SelectionMenu dynamicSelectionMenu = new SelectionMenu(this.selectionMenu.getShell(), event.getSource(), cursorPosition);
                dynamicSelectionMenu.setLabelProvider((ILabelProvider)new SelectionMenuLabelProvider());
                dynamicSelectionMenu.setContentProvider((IStructuredContentProvider)CollectionContentProvider.instance);
                dynamicSelectionMenu.setInput((Object)((NavigationSubMenuButton)((Object)hoveredItem)).getSubMenuElements());
                dynamicSelectionMenu.open();
                dynamicSelectionMenu.addSelectionChangedListener((ISelectionChangedListener)new SelectionMenuSelectionChangedListener(this.navigationMenu, dynamicSelectionMenu, ((NavigationSubMenuButton)((Object)hoveredItem)).getSubMenuElements(), this.umlElement, this.subMenus));
                dynamicSelectionMenu.addKeyListener((KeyListener)new NavigationMenuKeyListener(this.navigationMenu));
                dynamicSelectionMenu.addMouseTrackListener((MouseTrackListener)new SelectionMenuMouseTrackListener(this.navigationMenu, dynamicSelectionMenu, this.subMenus, this.umlElement));
                this.subMenus.add(dynamicSelectionMenu);
            }
        }
    }
}

