/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtrelation.environment;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractEssentialOCLOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.DomainPattern;
import org.eclipse.qvt.declarative.ecore.QVTRelation.QVTRelationFactory;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.ObjectTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.TemplateExp;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.AbstractDomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.DomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.PrimitiveTypeDomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrRelationEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTransformationEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTypedModelEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTrDomainEnvironment
extends QVTrEnvironment<QVTrRelationEnvironment, RelationDomain, AbstractDomainCS> {
    private final TypedModel typedModel;

    public QVTrDomainEnvironment(QVTrRelationEnvironment env, DomainCS domainCS) {
        super(env, QVTRelationFactory.eINSTANCE.createRelationDomain(), domainCS);
        IdentifierCS modelIdCS = domainCS.getModelId();
        this.setNameFromIdentifier((ENamedElement)this.ast, modelIdCS);
        QVTrTransformationEnvironment txEnv = (QVTrTransformationEnvironment)env.getParentEnvironment();
        RelationalTransformation transformation = txEnv.getRelationalTransformation();
        TypedModel typedModel = transformation.getModelParameter(modelIdCS.getValue());
        if (typedModel == null) {
            String message = "Domain identifier '" + modelIdCS.getValue() + "' must refer to a model parameter";
            this.analyzerError(message, "DomainCS", modelIdCS);
        }
        ((RelationDomain)this.ast).setTypedModel(typedModel);
        this.typedModel = typedModel;
    }

    public QVTrDomainEnvironment(QVTrRelationEnvironment env, PrimitiveTypeDomainCS domainCS) {
        super(env, QVTRelationFactory.eINSTANCE.createRelationDomain(), domainCS);
        this.typedModel = null;
    }

    public void createVariableDeclaration(VariableExpCS variableExpCS, EClassifier type) {
        ((QVTrRelationEnvironment)this.getParentEnvironment()).createVariableDeclaration(variableExpCS, type, (Domain)this.ast, false);
    }

    public RelationDomain getDomain() {
        return (RelationDomain)this.ast;
    }

    public String getModelName(EObject object) {
        QVTrTypedModelEnvironment env = ((QVTrTransformationEnvironment)((QVTrRelationEnvironment)this.getParentEnvironment()).getParentEnvironment()).getEnvironment(this.typedModel);
        if (env != null) {
            return env.getModelName(object);
        }
        return super.getModelName(object);
    }

    public void installPattern(TemplateExp templateExpression) {
        DomainPattern domainPattern = QVTRelationFactory.eINSTANCE.createDomainPattern();
        this.initASTMapping(domainPattern, this.cst, null);
        ((RelationDomain)this.ast).setPattern(domainPattern);
        domainPattern.setTemplateExpression(templateExpression);
        this.installPatternVariables((OCLExpression)templateExpression);
    }

    protected void installPatternVariables(OCLExpression expression) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (!(expression instanceof ObjectTemplateExp)) break block3;
                        ObjectTemplateExp objectTemplateExp = (ObjectTemplateExp)expression;
                        this.installPatternVariable(objectTemplateExp.getBindsTo());
                        for (PropertyTemplateItem part : objectTemplateExp.getPart()) {
                            this.installPatternVariables(part.getValue());
                        }
                        break block4;
                    }
                    if (!(expression instanceof CollectionTemplateExp)) break block5;
                    CollectionTemplateExp collectionTemplateExp = (CollectionTemplateExp)expression;
                    this.installPatternVariable(collectionTemplateExp.getBindsTo());
                    for (OCLExpression member : collectionTemplateExp.getMember()) {
                        this.installPatternVariables(member);
                    }
                    this.installPatternVariable(collectionTemplateExp.getRest());
                    break block4;
                }
                if (!(expression instanceof VariableExp)) break block6;
                VariableExp variableExp = (VariableExp)expression;
                Variable variable = (Variable)variableExp.getReferredVariable();
                if (variable == null || AbstractEssentialOCLOperations.locallyDefined((EObject)variableExp, (Variable)variable)) break block4;
                this.installPatternVariable(variable);
                break block4;
            }
            for (EObject eObject : expression.eContents()) {
                if (!(eObject instanceof OCLExpression)) continue;
                this.installPatternVariables((OCLExpression)eObject);
            }
        }
    }

    protected void installPatternVariable(Variable variable) {
        if (variable == null) {
            return;
        }
        if (this.isSpecialVariable(variable)) {
            return;
        }
        EList bindsTo = ((RelationDomain)this.ast).getPattern().getBindsTo();
        if (!bindsTo.contains(variable)) {
            bindsTo.add(variable);
        }
    }

    public EClass lookupImportedClass(String name) {
        if (this.typedModel != null) {
            for (EPackage ePackage : this.typedModel.getUsedPackage()) {
                EClassifier eClassifier = ePackage.getEClassifier(name);
                if (!(eClassifier instanceof EClass)) continue;
                return (EClass)eClassifier;
            }
        }
        return null;
    }

    public EClassifier lookupImportedClassifier(String name) {
        if (this.typedModel != null) {
            for (EPackage ePackage : this.typedModel.getUsedPackage()) {
                EClassifier eClassifier = ePackage.getEClassifier(name);
                if (eClassifier == null) continue;
                return eClassifier;
            }
        }
        return null;
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        EClassifier eClassifier;
        if (this.typedModel != null && (eClassifier = this.tryLookupClassifier((Collection)this.typedModel.getUsedPackage(), names)) != null) {
            return eClassifier;
        }
        return super.tryLookupClassifier(names);
    }
}

