/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ExpressionSynthesizer;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleHeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.UtilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.AssignmentSorter;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.IsConstantExpressionVisitor;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.BottomVariable;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardVariable;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.util.QVTcoreVisitor;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class MappingAnalysis
extends RuleAnalysis {
    private final @NonNull Set<@NonNull Predicate> complexPredicates = new HashSet<Predicate>();
    private final @NonNull List<@NonNull GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
    private final @NonNull List<@NonNull BottomPattern> bottomPatterns = new ArrayList<BottomPattern>();
    private final @NonNull List<@NonNull NavigationAssignment> navigationAssignments = new ArrayList<NavigationAssignment>();
    private @NonNull Map<@NonNull VariableDeclaration, @NonNull List<@NonNull OCLExpression>> variable2expressions = new HashMap<VariableDeclaration, List<OCLExpression>>();

    public MappingAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull RuleRegion ruleRegion) {
        super(transformationAnalysis, ruleRegion);
        Mapping mapping = (Mapping)QVTscheduleUtil.getReferredRule((RuleRegion)ruleRegion);
        GuardPattern guardPattern = QVTcoreUtil.getGuardPattern((Area)mapping);
        BottomPattern bottomPattern = QVTcoreUtil.getBottomPattern((Area)mapping);
        this.guardPatterns.add(guardPattern);
        this.bottomPatterns.add(bottomPattern);
        for (Assignment assignment : QVTcoreUtil.getOwnedAssignments((BottomPattern)bottomPattern)) {
            if (assignment instanceof NavigationAssignment) {
                this.navigationAssignments.add((NavigationAssignment)assignment);
                continue;
            }
            if (!(assignment instanceof VariableAssignment)) continue;
            VariableAssignment variableAssignment = (VariableAssignment)assignment;
            this.addExpression((VariableDeclaration)QVTcoreUtil.getTargetVariable((VariableAssignment)variableAssignment), QVTcoreUtil.getValue((Assignment)variableAssignment));
        }
        for (CoreDomain coreDomain : QVTcoreUtil.getOwnedDomains((Mapping)mapping)) {
            guardPattern = QVTcoreUtil.getGuardPattern((Area)coreDomain);
            bottomPattern = QVTcoreUtil.getBottomPattern((Area)coreDomain);
            this.guardPatterns.add(guardPattern);
            this.bottomPatterns.add(bottomPattern);
            for (Assignment assignment : QVTcoreUtil.getOwnedAssignments((BottomPattern)bottomPattern)) {
                if (assignment instanceof NavigationAssignment) {
                    this.navigationAssignments.add((NavigationAssignment)assignment);
                    continue;
                }
                if (!(assignment instanceof VariableAssignment)) continue;
                VariableAssignment variableAssignment = (VariableAssignment)assignment;
                this.addExpression((VariableDeclaration)QVTcoreUtil.getTargetVariable((VariableAssignment)variableAssignment), QVTcoreUtil.getValue((Assignment)variableAssignment));
            }
        }
    }

    protected void addExpression(@NonNull VariableDeclaration variable, @NonNull OCLExpression expression) {
        List<@NonNull OCLExpression> initializers = this.variable2expressions.get(variable);
        if (initializers == null) {
            initializers = new ArrayList<OCLExpression>();
            this.variable2expressions.put(variable, initializers);
        }
        if (!initializers.contains(expression)) {
            initializers.add(expression);
        }
    }

    protected void analyzeAssignmentValues() {
        AssignmentSorter assignmentSorter = new AssignmentSorter();
        for (BottomPattern bottomPattern : this.bottomPatterns) {
            assignmentSorter.addAll((Iterable<Assignment>)ClassUtil.nullFree((EList)bottomPattern.getAssignment()));
        }
        for (Assignment assignment : assignmentSorter.getSortedAssignments()) {
            assignment.accept((Visitor)this.expressionSynthesizer);
        }
    }

    protected void analyzeComplexPredicates() {
        for (Predicate predicate : this.complexPredicates) {
            OCLExpression conditionExpression = predicate.getConditionExpression();
            Node resultNode = (Node)conditionExpression.accept((Visitor)this.expressionSynthesizer);
            if (resultNode == null) continue;
            BooleanLiteralNode trueNode = this.createBooleanLiteralNode(true);
            this.createPredicateEdge(resultNode, null, (Node)trueNode);
        }
    }

    protected void analyzeContainments() {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isNew()) continue;
            boolean isContained = false;
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                NavigationEdge navigationEdge;
                Property property;
                Property opposite;
                if (!edge.isNavigation() || (opposite = (property = QVTscheduleUtil.getReferredProperty((NavigationEdge)(navigationEdge = (NavigationEdge)edge))).getOpposite()) == null || !opposite.isIsComposite() || edge.getEdgeTarget().isNullLiteral()) continue;
                isContained = true;
                break;
            }
            if (!isContained) continue;
            node.setContained(true);
        }
    }

    protected void analyzeGuardVariables() {
        for (GuardPattern guardPattern : this.guardPatterns) {
            for (Variable guardVariable : ClassUtil.nullFree((EList)guardPattern.getVariable())) {
                Node guardNode = ((RuleRegion)this.region).getNode((TypedElement)guardVariable);
                assert (guardNode == null);
                guardNode = this.createOldNode((VariableDeclaration)guardVariable);
                assert (guardNode == ((RuleRegion)this.region).getNode((TypedElement)guardVariable));
            }
        }
    }

    protected void analyzePredicates(@NonNull List<@NonNull ? extends CorePattern> corePatterns) {
        for (CorePattern corePattern : corePatterns) {
            for (Predicate predicate : ClassUtil.nullFree((EList)corePattern.getPredicate())) {
                OCLExpression referenceExpression;
                OCLExpression conditionExpression = predicate.getConditionExpression();
                if (conditionExpression == null) continue;
                OCLExpression boundExpression = this.getPredicateComparisonBoundExpression(conditionExpression);
                if (boundExpression instanceof VariableExp) {
                    referenceExpression = this.getPredicateComparisonReferenceExpression(conditionExpression);
                    assert (referenceExpression != null);
                    Variable referredVariable = QVTcoreUtil.getReferredVariable((VariableExp)((VariableExp)boundExpression));
                    if (this.analyzeSimplePredicate((VariableDeclaration)referredVariable, referenceExpression)) continue;
                    this.complexPredicates.add(predicate);
                    continue;
                }
                if (boundExpression instanceof NullLiteralExp) {
                    referenceExpression = this.getPredicateComparisonReferenceExpression(conditionExpression);
                    assert (referenceExpression != null);
                    if (this.analyzeSimplePredicate(null, referenceExpression)) continue;
                    this.complexPredicates.add(predicate);
                    continue;
                }
                this.complexPredicates.add(predicate);
            }
        }
    }

    protected void analyzeRealizedVariables() {
        for (BottomPattern bottomPattern : this.bottomPatterns) {
            for (RealizedVariable realizedVariable : ClassUtil.nullFree((EList)bottomPattern.getRealizedVariable())) {
                Node realizedNode = ((RuleRegion)this.region).getNode((TypedElement)realizedVariable);
                assert (realizedNode == null);
                realizedNode = this.createRealizedStepNode((VariableDeclaration)realizedVariable);
                assert (realizedNode == ((RuleRegion)this.region).getNode((TypedElement)realizedVariable));
            }
        }
    }

    @Override
    public void analyzeMappingRegion() {
        this.analyzeGuardVariables();
        this.analyzeRealizedVariables();
        this.analyzePredicates(this.guardPatterns);
        this.analyzePredicates(this.bottomPatterns);
        this.analyzeAssignmentValues();
        this.analyzeComplexPredicates();
        this.analyzeContainments();
        this.rewriteCastEdges();
        Iterable<@NonNull Node> headNodes = RuleHeadAnalysis.computeRuleHeadNodes(this.scheduleManager, (MappingRegion)this.region, null);
        Iterables.addAll((Collection)QVTscheduleUtil.Internal.getHeadNodesList((Region)this.region), headNodes);
        UtilityAnalysis.assignUtilities(this.scheduleManager, this.region);
    }

    private boolean analyzeSimplePredicate(@Nullable VariableDeclaration boundVariable, @NonNull OCLExpression referenceExpression) {
        NavigationCallExp navigationCallExp;
        boolean isValid = false;
        OCLExpression expression = referenceExpression;
        while (expression instanceof NavigationCallExp) {
            navigationCallExp = (NavigationCallExp)expression;
            if (!((expression = (OCLExpression)ClassUtil.nonNullState((Object)navigationCallExp.getOwnedSource())) instanceof VariableExp)) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            return false;
        }
        expression = referenceExpression;
        while (expression instanceof NavigationCallExp) {
            Node targetNode;
            navigationCallExp = (NavigationCallExp)expression;
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
            assert (referredProperty != null);
            expression = (OCLExpression)ClassUtil.nonNullState((Object)navigationCallExp.getOwnedSource());
            if (!(expression instanceof VariableExp)) continue;
            VariableDeclaration sourceVariable = ((VariableExp)expression).getReferredVariable();
            assert (sourceVariable != null);
            Node sourceNode = this.getReferenceNode(sourceVariable);
            Node node = targetNode = boundVariable != null ? this.getReferenceNode(boundVariable) : this.createNullLiteralNode(true, null);
            assert (sourceNode.isClass());
            if (referredProperty.isIsMany()) continue;
            Edge predicateEdge = sourceNode.getOutgoingPredicateEdge(referredProperty);
            if (predicateEdge == null) {
                this.createNavigationEdge(sourceNode, referredProperty, targetNode, false);
                continue;
            }
            assert (predicateEdge.getEdgeTarget() == targetNode);
        }
        return true;
    }

    private @Nullable Node analyzeVariable(@NonNull Variable variable, @NonNull List<@NonNull OCLExpression> expressions) {
        ClassDatum variableClassDatum;
        OCLExpression bestInitExpression = null;
        for (OCLExpression initExpression : expressions) {
            OperationCallExp operationCallExp;
            OperationId operationId;
            if (!(initExpression instanceof OperationCallExp) || PivotUtil.isSameOperation((OperationId)(operationId = (operationCallExp = (OperationCallExp)initExpression).getReferredOperation().getOperationId()), (OperationId)OperationId.OCLANY_EQUALS) || PivotUtil.isSameOperation((OperationId)operationId, (OperationId)OperationId.OCLANY_NOT_EQUALS)) continue;
            bestInitExpression = initExpression;
            break;
        }
        if (bestInitExpression == null) {
            OCLExpression oCLExpression = bestInitExpression = expressions.size() > 0 ? expressions.get(0) : null;
        }
        if (bestInitExpression == null) {
            return null;
        }
        Node bestInitNode = (Node)bestInitExpression.accept((Visitor)this.expressionSynthesizer);
        assert (bestInitNode != null);
        ClassDatum initClassDatum = QVTscheduleUtil.getClassDatum((Node)bestInitNode);
        if (!QVTscheduleUtil.conformsTo((ClassDatum)initClassDatum, (ClassDatum)(variableClassDatum = this.scheduleManager.getClassDatum((TypedElement)variable)))) {
            VariableNode castNode = this.createOldNode((VariableDeclaration)variable);
            this.expressionSynthesizer.createCastEdge(bestInitNode, variableClassDatum, (Node)castNode);
            bestInitNode = castNode;
        }
        bestInitNode.setOriginatingVariable((VariableDeclaration)variable);
        ((RuleRegion)this.region).addVariableNode((VariableDeclaration)variable, bestInitNode);
        for (OCLExpression initExpression : expressions) {
            if (initExpression == bestInitExpression) continue;
            Node initNode = (Node)bestInitExpression.accept((Visitor)this.expressionSynthesizer);
            assert (initNode != null);
            this.createEqualsEdge(bestInitNode, initNode);
        }
        return bestInitNode;
    }

    private @Nullable OCLExpression getPredicateComparisonBoundExpression(@NonNull OCLExpression conditionExpression) {
        OperationCallExp callExp;
        OperationId operationId;
        if (conditionExpression instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationId = (callExp = (OperationCallExp)conditionExpression).getReferredOperation().getOperationId()), (OperationId)this.scheduleManager.getStandardLibraryHelper().getOclAnyEqualsId())) {
            OCLExpression leftExp = callExp.getOwnedSource();
            if (leftExp instanceof VariableExp) {
                return leftExp;
            }
            OCLExpression rightExp = (OCLExpression)callExp.getOwnedArguments().get(0);
            if (rightExp instanceof VariableExp) {
                return rightExp;
            }
            IsConstantExpressionVisitor isConstantExpressionVisitor = new IsConstantExpressionVisitor(null);
            if (isConstantExpressionVisitor.isConstant((Visitable)leftExp)) {
                return leftExp;
            }
            if (isConstantExpressionVisitor.isConstant((Visitable)rightExp)) {
                return rightExp;
            }
        }
        return null;
    }

    private @Nullable OCLExpression getPredicateComparisonReferenceExpression(@NonNull OCLExpression conditionExpression) {
        OperationCallExp callExp;
        OperationId operationId;
        if (conditionExpression instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationId = (callExp = (OperationCallExp)conditionExpression).getReferredOperation().getOperationId()), (OperationId)this.scheduleManager.getStandardLibraryHelper().getOclAnyEqualsId())) {
            OCLExpression leftExp = callExp.getOwnedSource();
            OCLExpression rightExp = (OCLExpression)callExp.getOwnedArguments().get(0);
            if (leftExp instanceof VariableExp) {
                return rightExp;
            }
            if (rightExp instanceof VariableExp) {
                return leftExp;
            }
            IsConstantExpressionVisitor isConstantExpressionVisitor = new IsConstantExpressionVisitor(null);
            if (isConstantExpressionVisitor.isConstant((Visitable)leftExp)) {
                return rightExp;
            }
            if (isConstantExpressionVisitor.isConstant((Visitable)rightExp)) {
                return leftExp;
            }
        }
        return null;
    }

    @Override
    public @NonNull Node getReferenceNode(@NonNull VariableDeclaration variableDeclaration) {
        Node node = ((RuleRegion)this.region).getNode((TypedElement)variableDeclaration);
        if (node == null && variableDeclaration instanceof Variable) {
            List<OCLExpression> expressions;
            Variable variable = (Variable)variableDeclaration;
            OCLExpression ownedInit = variable.getOwnedInit();
            if (ownedInit != null) {
                this.addExpression((VariableDeclaration)variable, ownedInit);
            }
            if ((expressions = this.variable2expressions.get(variable)) != null) {
                node = this.analyzeVariable(variable, expressions);
            } else if (variable.eContainer() instanceof BottomPattern) {
                boolean isEnforceable;
                DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)variable);
                boolean bl = isEnforceable = domainUsage.isOutput() || domainUsage.isMiddle();
                if (isEnforceable) {
                    if (!(variable instanceof RealizedVariable)) {
                        this.scheduleManager.addRegionError(this.region, "Enforceable variable ''{0}'' has not been realized in ''{1}''", variable, this.region);
                    }
                    node = this.createRealizedStepNode((VariableDeclaration)variable);
                } else {
                    node = this.createLoadedStepNode((VariableDeclaration)variable);
                }
            }
        }
        assert (node != null) : "No variable2simpleNode entry for " + variableDeclaration;
        return node;
    }

    @Override
    public boolean isPropertyAssignment(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        if (sourceNode.isRealized()) {
            for (NavigationAssignment navigationAssignment : this.navigationAssignments) {
                Node slotNode;
                Property navigationProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
                if (source2targetProperty != navigationProperty || (slotNode = this.expressionSynthesizer.synthesize((Visitable)navigationAssignment.getSlotExpression())) != sourceNode) continue;
                return true;
            }
        }
        return false;
    }

    public static abstract class AbstractQVTcoreExpressionSynthesizer
    extends ExpressionSynthesizer
    implements QVTcoreVisitor<Node> {
        protected AbstractQVTcoreExpressionSynthesizer(@NonNull RuleAnalysis context) {
            super(context);
        }

        public @Nullable Node visitAssignment(@NonNull Assignment object) {
            return this.visitElement((Element)object);
        }

        public @Nullable Node visitBottomPattern(@NonNull BottomPattern object) {
            return this.visitCorePattern((CorePattern)object);
        }

        public @Nullable Node visitBottomVariable(@NonNull BottomVariable object) {
            return (Node)this.visitVariable((Variable)object);
        }

        public @Nullable Node visitCoreDomain(@NonNull CoreDomain object) {
            return (Node)this.visitDomain((Domain)object);
        }

        public @Nullable Node visitCoreModel(@NonNull CoreModel object) {
            return (Node)this.visitBaseModel((BaseModel)object);
        }

        public @Nullable Node visitCorePattern(@NonNull CorePattern object) {
            return (Node)this.visitPattern((Pattern)object);
        }

        public @Nullable Node visitEnforcementOperation(@NonNull EnforcementOperation object) {
            return this.visitElement((Element)object);
        }

        public @Nullable Node visitGuardPattern(@NonNull GuardPattern object) {
            return this.visitCorePattern((CorePattern)object);
        }

        public @Nullable Node visitGuardVariable(@NonNull GuardVariable object) {
            return (Node)this.visitVariable((Variable)object);
        }

        public @Nullable Node visitMapping(@NonNull Mapping object) {
            return (Node)this.visitRule((Rule)object);
        }

        public @Nullable Node visitNavigationAssignment(@NonNull NavigationAssignment object) {
            return this.visitAssignment((Assignment)object);
        }

        public @Nullable Node visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment object) {
            return this.visitNavigationAssignment((NavigationAssignment)object);
        }

        public @Nullable Node visitPropertyAssignment(@NonNull PropertyAssignment object) {
            return this.visitNavigationAssignment((NavigationAssignment)object);
        }

        public @Nullable Node visitRealizedVariable(@NonNull RealizedVariable object) {
            return (Node)this.visitVariable((Variable)object);
        }

        public @Nullable Node visitVariableAssignment(@NonNull VariableAssignment object) {
            return this.visitAssignment((Assignment)object);
        }
    }

    public static class ConditionalExpressionSynthesizer
    extends QVTcoreExpressionSynthesizer {
        protected ConditionalExpressionSynthesizer(@NonNull RuleAnalysis context) {
            super(context);
        }

        @Override
        protected @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode) {
            return ((RuleAnalysis)((Object)this.context)).createStepNode(name, callExp, sourceNode, false);
        }

        @Override
        protected boolean isUnconditional() {
            return false;
        }
    }

    public static class QVTcoreExpressionSynthesizer
    extends AbstractQVTcoreExpressionSynthesizer {
        protected QVTcoreExpressionSynthesizer(@NonNull RuleAnalysis context) {
            super(context);
        }

        @Override
        protected @NonNull ExpressionSynthesizer createConditionalExpressionSynthesizer() {
            return new ConditionalExpressionSynthesizer((RuleAnalysis)((Object)this.context));
        }

        @Override
        protected @NonNull ExpressionSynthesizer createRequiredExpressionSynthesizer() {
            return new RequiredExpressionSynthesizer((RuleAnalysis)((Object)this.context));
        }

        @Override
        public @NonNull Node visitNavigationAssignment(@NonNull NavigationAssignment asNavigationAssignment) {
            CompleteClass targetCompleteClass;
            Node slotNode = this.synthesize((Visitable)asNavigationAssignment.getSlotExpression());
            assert (slotNode.isClass());
            Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)asNavigationAssignment);
            OCLExpression value = QVTcoreUtil.getValue((Assignment)asNavigationAssignment);
            this.helper.rewriteSafeNavigations((Element)value);
            Node targetNode = this.synthesize((Visitable)value);
            NavigableEdge navigationEdge = this.getNavigationEdge(slotNode, property, targetNode, asNavigationAssignment);
            Node valueNode = navigationEdge.getEdgeTarget();
            ClassDatum valueClassDatum = QVTscheduleUtil.getClassDatum((Node)valueNode);
            Type propertyType = PivotUtil.getType((TypedElement)property);
            if (asNavigationAssignment.isIsPartial()) {
                propertyType = PivotUtil.getElementType((CollectionType)((CollectionType)propertyType));
            }
            if (!QVTscheduleUtil.conformsToClassOrBehavioralClass((ClassDatum)valueClassDatum, (CompleteClass)(targetCompleteClass = this.environmentFactory.getCompleteModel().getCompleteClass(propertyType))) && !QVTscheduleUtil.conformsToClassOrBehavioralClass((ClassDatum)valueClassDatum, (CompleteClass)targetCompleteClass)) {
                throw new IllegalStateException("Incompatible types " + valueClassDatum + ", " + targetCompleteClass + " for " + asNavigationAssignment);
            }
            return slotNode;
        }

        @Override
        public @NonNull Node visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment asNavigationAssignment) {
            return this.visitNavigationAssignment((NavigationAssignment)asNavigationAssignment);
        }

        @Override
        public @NonNull Node visitPropertyAssignment(@NonNull PropertyAssignment asNavigationAssignment) {
            return this.visitNavigationAssignment((NavigationAssignment)asNavigationAssignment);
        }

        @Override
        public @Nullable Node visitVariableAssignment(@NonNull VariableAssignment variableAssignment) {
            return null;
        }
    }

    public static class RequiredExpressionSynthesizer
    extends QVTcoreExpressionSynthesizer {
        protected RequiredExpressionSynthesizer(@NonNull RuleAnalysis context) {
            super(context);
        }

        @Override
        protected @NonNull Node createOperationCallNode(@NonNull CallExp callExp, @NonNull Operation operation, @NonNull Node @NonNull [] sourceAndArgumentNodes) {
            Node operationCallNode = super.createOperationCallNode(callExp, operation, sourceAndArgumentNodes);
            operationCallNode.setRequired();
            return operationCallNode;
        }

        @Override
        protected boolean isRequired() {
            return true;
        }
    }
}

