/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.adapter;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.adapter.IModelAdapter;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.EnumLiteral;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.HasFields;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFModelAdapter
implements IModelAdapter {
    private boolean allowInterModelReferences;

    @Override
    public void setAllowInterModelReferences(boolean allowInterModelRefs) {
        this.allowInterModelReferences = allowInterModelRefs;
    }

    public static Object getNameOf(EObject eo) {
        Object ret = null;
        EClass ec = eo.eClass();
        EStructuralFeature sf = ec.getEStructuralFeature("name");
        if (sf != null) {
            ret = eo.eGet(sf);
        }
        if (ret == null) {
            ret = "<unnamed>";
        }
        return ret;
    }

    public static EEnumLiteral getEENumLiteral(EEnum eEnum, String id) {
        EEnumLiteral ret = eEnum.getEEnumLiteralByLiteral(id);
        if (ret == null) {
            ret = eEnum.getEEnumLiteral(id);
        }
        return ret;
    }

    @Override
    public List<Object> getSupertypes(Object type) {
        EList ret = null;
        if (type != null) {
            if (type instanceof EClass) {
                ret = ((EClass)type).getESuperTypes();
                if (ret.size() == 0) {
                    ret = Arrays.asList(Object.class);
                } else {
                    EList sts = ret;
                    ret = new ArrayList(sts.size());
                    int i = sts.size() - 1;
                    while (i >= 0) {
                        ret.add(sts.get(i));
                        --i;
                    }
                }
            } else {
                Class sc;
                ret = OclType.getSupertypes().get(type);
                if (ret == null && (sc = ((Class)type).getSuperclass()) != null) {
                    ret = Arrays.asList(sc);
                }
            }
        }
        if (ret == null) {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    @Override
    public Object getType(Object value) {
        if (value instanceof EObject) {
            return ((EObject)value).eClass();
        }
        if (value instanceof EList) {
            return ArrayList.class;
        }
        return value.getClass();
    }

    @Override
    public boolean prettyPrint(ExecEnv execEnv, PrintStream out, Object value) {
        if (value instanceof EClass) {
            EClass c = (EClass)value;
            String mName = execEnv.getModelNameOf(c);
            if (mName != null) {
                out.print(mName);
            } else {
                out.print("<unknown>");
            }
            out.print('!');
            String name = c.getName();
            if (name == null) {
                name = "<unnamed>";
            }
            out.print(name);
            return true;
        }
        if (value instanceof EObject) {
            EObject eo = (EObject)value;
            IModel model = execEnv.getModelOf(eo);
            if (model != null) {
                out.print(execEnv.getNameOf(model));
            } else {
                out.print("<unknown>");
            }
            out.print('!');
            out.print(EMFModelAdapter.getNameOf(eo));
            out.print(':');
            if (model != null) {
                IReferenceModel mModel = model.getReferenceModel();
                out.print(execEnv.getNameOf((IModel)mModel));
                out.print('!');
                String name = eo.eClass().getName();
                if (name == null) {
                    name = "<unnamed>";
                }
                out.print(name);
            } else {
                this.prettyPrint(execEnv, out, eo.eClass());
            }
            return true;
        }
        if (value instanceof EList) {
            out.print("Sequence {");
            execEnv.prettyPrintCollection(out, (Collection<?>)((EList)value));
            return true;
        }
        return false;
    }

    @Override
    public void registerVMSupertypes(Map<Class<?>, List<Class<?>>> vmSupertypes) {
        vmSupertypes.put(EClassImpl.class, Arrays.asList(EObjectImpl.class));
    }

    @Override
    public void registerVMTypeOperations(Map<Object, Map<String, Operation>> vmTypeOperations) {
        Map<String, Operation> operationsByName = vmTypeOperations.get(Object.class);
        operationsByName.put("=", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[0] instanceof Enumerator) {
                    return new Boolean(localVars[1].equals(localVars[0]));
                }
                return new Boolean(localVars[0].equals(localVars[1]));
            }
        });
        operationsByName.put("refGetValue", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[0] instanceof EObject) {
                    return EMFModelAdapter.this.get(frame, (EObject)localVars[0], (String)localVars[1]);
                }
                return ((HasFields)localVars[0]).get(frame, localVars[1]);
            }
        });
        operationsByName.put("refSetValue", new Operation(3){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[0] instanceof EObject) {
                    EMFModelAdapter.this.set(frame, (EObject)localVars[0], (String)localVars[1], localVars[2]);
                } else {
                    ((HasFields)localVars[0]).set(frame, localVars[1], localVars[2]);
                }
                return localVars[0];
            }
        });
        operationsByName.put("refUnSetValue", new Operation(3){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[0] instanceof EObject) {
                    EMFModelAdapter.this.unSet(frame, (EObject)localVars[0], (String)localVars[1]);
                }
                return localVars[0];
            }
        });
        operationsByName.put("oclType", new Operation(1){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[0] instanceof EObject) {
                    return ((EObject)localVars[0]).eClass();
                }
                return OclType.getOclTypeFromObject(localVars[0]);
            }
        });
        operationsByName.put("oclIsTypeOf", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[1] instanceof Class) {
                    return new Boolean(localVars[1].equals(localVars[0].getClass()));
                }
                if (localVars[1] instanceof EClass) {
                    if (localVars[0] instanceof EObject) {
                        return new Boolean(localVars[1].equals(((EObject)localVars[0]).eClass()));
                    }
                    return Boolean.FALSE;
                }
                if (localVars[1] instanceof OclType) {
                    return new Boolean(((OclType)localVars[1]).equals(OclType.getOclTypeFromObject(localVars[0])));
                }
                throw new VMException(frame, Messages.getString("EMFModelAdapter.UNHANDLEDTYPE", localVars[1]));
            }
        });
        operationsByName.put("oclIsKindOf", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[1] instanceof Class) {
                    return new Boolean(((Class)localVars[1]).isInstance(localVars[0]));
                }
                if (localVars[1] instanceof EClass) {
                    return new Boolean(((EClass)localVars[1]).isInstance(localVars[0]));
                }
                if (localVars[1] instanceof OclType) {
                    OclType selfType = OclType.getOclTypeFromObject(localVars[0]);
                    return new Boolean(selfType.conformsTo((OclType)localVars[1]));
                }
                throw new VMException(frame, Messages.getString("EMFModelAdapter.UNHANDLEDTYPE", localVars[1]));
            }
        });
        operationsByName.put("refImmediateComposite", new Operation(1){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                if (localVars[0] instanceof EObject) {
                    Object ret = ((EObject)localVars[0]).eContainer();
                    if (ret == null) {
                        ret = OclUndefined.SINGLETON;
                    }
                    return ret;
                }
                throw new VMException(frame, Messages.getString("EMFModelAdapter.REFIMMEDIATECOMPOSITE"));
            }
        });
        operationsByName = new HashMap<String, Operation>();
        vmTypeOperations.put(EcorePackage.eINSTANCE.getEClass(), operationsByName);
        operationsByName.put("allInstancesFrom", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                IModel model = frame.getExecEnv().getModel(localVars[1]);
                if (model == null) {
                    throw new VMException(frame, Messages.getString("EMFModelAdapter.MODELNOTFOUND", localVars[1]));
                }
                return model.getElementsByType(localVars[0]);
            }
        });
        operationsByName.put("allInstances", new Operation(1){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                LinkedHashSet ret = new LinkedHashSet();
                EClass ec = (EClass)localVars[0];
                for (IModel model : frame.getExecEnv().getModelsByName().values()) {
                    if (!model.getReferenceModel().isModelOf((Object)ec)) continue;
                    ret.addAll(model.getElementsByType((Object)ec));
                }
                return ret;
            }
        });
        operationsByName.put("registerHelperAttribute", new Operation(3){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                String name = (String)localVars[1];
                String initOperationName = (String)localVars[2];
                frame.getExecEnv().registerHelperAttribute(localVars[0], name, initOperationName);
                return null;
            }
        });
        operationsByName.put("newInstance", new Operation(1){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                EClass ec = (EClass)localVars[0];
                return frame.getExecEnv().newElement(frame, ec);
            }
        });
        operationsByName.put("newInstanceIn", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                EClass ec = (EClass)localVars[0];
                String modelName = (String)localVars[1];
                return frame.getExecEnv().newElementIn(frame, ec, modelName);
            }
        });
        operationsByName.put("getInstanceById", new Operation(3){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                EMFModel model = (EMFModel)frame.getExecEnv().getModel(localVars[1]);
                Resource resource = model.getResource();
                Object ret = resource.getEObject((String)localVars[2]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("conformsTo", new Operation(2){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                return new Boolean(((EClass)localVars[1]).isSuperTypeOf((EClass)localVars[0]));
            }
        });
    }

    @Override
    public Object get(AbstractStackFrame frame, Object modelElement, String name) {
        Object ret = null;
        if (modelElement == null || modelElement.equals(OclUndefined.SINGLETON)) {
            throw new VMException(frame, Messages.getString("EMFModelAdapter.GET_PROBLEM", name));
        }
        EObject eo = (EObject)modelElement;
        EClass ec = eo.eClass();
        if (frame != null && frame.getExecEnv().isHelper(ec, name)) {
            ret = frame.getExecEnv().getHelperValue(frame, ec, eo, name);
        } else if ("__xmiID__".equals(name)) {
            ret = this.getID(eo);
        } else {
            EStructuralFeature sf = ec.getEStructuralFeature(name);
            if (sf == null) {
                throw new VMException(frame, Messages.getString("EMFModelAdapter.FEATURE_NOT_EXISTS", name, ec.getName()));
            }
            ArrayList<EnumLiteral> val = eo.eGet(sf);
            if (val == null) {
                val = OclUndefined.SINGLETON;
            } else if (val instanceof Enumerator) {
                val = new EnumLiteral(((Object)val).toString());
            } else if (val instanceof Collection && sf.getEType() instanceof EEnum) {
                ArrayList<EnumLiteral> c = new ArrayList<EnumLiteral>();
                for (Object v : (Collection)val) {
                    c.add(new EnumLiteral(v.toString()));
                }
                val = c;
            }
            ret = val;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(AbstractStackFrame frame, Object modelElement, String name, Object value) {
        String targetType;
        Object settableValue = value;
        if (settableValue == null || value.equals(OclUndefined.SINGLETON)) {
            return;
        }
        EObject eo = (EObject)modelElement;
        if ("__xmiID__".equals(name)) {
            this.setID(eo, value);
        }
        EStructuralFeature feature = eo.eClass().getEStructuralFeature(name);
        if (frame != null && frame.getExecEnv().isWeavingHelper(eo.eClass(), name)) {
            frame.getExecEnv().setHelperValue(modelElement, name, value);
            return;
        }
        if (feature == null) {
            throw new VMException(frame, Messages.getString("EMFModelAdapter.FEATURE_NOT_EXISTS", name, eo.eClass().getName()));
        }
        if (settableValue instanceof Integer) {
            targetType = feature.getEType().getInstanceClassName();
            if ("java.lang.Double".equals(targetType) || "double".equals(targetType)) {
                settableValue = new Double(((Integer)value).doubleValue());
            } else if ("java.lang.Float".equals(targetType) || "float".equals(targetType)) {
                settableValue = new Float(((Integer)value).floatValue());
            }
        } else if (settableValue instanceof Double && ("java.lang.Float".equals(targetType = feature.getEType().getInstanceClassName()) || "float".equals(targetType))) {
            settableValue = new Float(((Double)value).floatValue());
        }
        EClassifier type = feature.getEType();
        boolean targetIsEnum = type instanceof EEnum;
        try {
            ExecEnv execEnv = frame.getExecEnv();
            Object oldValue = eo.eGet(feature);
            if (oldValue instanceof Collection) {
                Collection oldCol = (Collection)oldValue;
                if (settableValue instanceof Collection) {
                    if (targetIsEnum) {
                        EEnum eenum = (EEnum)type;
                        for (Object v : (Collection)settableValue) {
                            oldCol.add(EMFModelAdapter.getEENumLiteral(eenum, v.toString()).getInstance());
                        }
                        return;
                    } else {
                        for (Object v : (Collection)settableValue) {
                            if (v instanceof EObject) {
                                EReference ref;
                                if (execEnv.getModelOf(eo) == execEnv.getModelOf(v)) {
                                    oldCol.add(v);
                                    continue;
                                }
                                if (!this.allowInterModelReferences || !(feature instanceof EReference) || (ref = (EReference)feature).isContainer() || ref.isContainment()) continue;
                                oldCol.add(v);
                                continue;
                            }
                            oldCol.add(v);
                        }
                    }
                    return;
                } else if (targetIsEnum) {
                    EEnum eenum = (EEnum)type;
                    oldCol.add(EMFModelAdapter.getEENumLiteral(eenum, settableValue.toString()).getInstance());
                    return;
                } else if (this.allowInterModelReferences || !(settableValue instanceof EObject)) {
                    oldCol.add(settableValue);
                    return;
                } else {
                    if (execEnv.getModelOf(eo) != execEnv.getModelOf(settableValue)) return;
                    oldCol.add(settableValue);
                }
                return;
            } else {
                if (settableValue instanceof Collection) {
                    ATLLogger.warning((String)Messages.getString("EMFModelAdapter.ASSIGNMENTWARNING"));
                    Collection c = (Collection)settableValue;
                    settableValue = !c.isEmpty() ? c.iterator().next() : null;
                }
                if (targetIsEnum) {
                    EEnum eenum = (EEnum)type;
                    if (settableValue == null) return;
                    EEnumLiteral literal = EMFModelAdapter.getEENumLiteral(eenum, settableValue.toString());
                    if (literal == null) throw new VMException(frame, Messages.getString("EMFModelAdapter.LITERALERROR", settableValue, eenum.getName()));
                    eo.eSet(feature, (Object)literal.getInstance());
                    return;
                } else if (this.allowInterModelReferences || !(settableValue instanceof EObject)) {
                    eo.eSet(feature, settableValue);
                    return;
                } else {
                    if (execEnv.getModelOf(eo) != execEnv.getModelOf(settableValue)) return;
                    eo.eSet(feature, settableValue);
                }
            }
            return;
        }
        catch (ClassCastException e) {
            throw new VMException(frame, e.getMessage(), e);
        }
        catch (ArrayStoreException e) {
            throw new VMException(frame, e.getMessage(), e);
        }
    }

    @Override
    public void unSet(AbstractStackFrame frame, Object modelElement, String name) {
        EObject eo = (EObject)modelElement;
        EStructuralFeature feature = eo.eClass().getEStructuralFeature(name);
        if (feature == null) {
            throw new VMException(frame, Messages.getString("EMFModelAdapter.FEATURE_NOT_EXISTS", name, eo.eClass().getName()));
        }
        eo.eUnset(feature);
    }

    @Override
    public void delete(AbstractStackFrame frame, Object modelElement) {
        EObject eo = (EObject)modelElement;
        eo.eAdapters().clear();
        EcoreUtil.remove((EObject)eo);
    }

    @Override
    public Object invoke(Method method, Object self, Object[] arguments) {
        Object res = null;
        try {
            res = method.invoke(self, arguments);
        }
        catch (IllegalAccessException e) {
            throw new VMException(null, Messages.getString("EMFModelAdapter.UNABLE_TO_INVOKE_OPERATION", method.getName(), self), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Exception toReport = cause instanceof Exception ? (Exception)cause : e;
            throw new VMException(null, Messages.getString("EMFModelAdapter.INVOKE_OPERATION_ERROR", method.getName(), self), toReport);
        }
        return res == null && method.getReturnType() != Void.TYPE ? OclUndefined.SINGLETON : res;
    }

    @Override
    public void finalizeModel(IModel model) {
        if (model.isTarget()) {
            ((EMFModel)model).commitToResource();
        }
    }

    @Override
    public Object getID(Object element) {
        if (element instanceof EObject) {
            EObject eo = (EObject)element;
            return eo.eResource().getURIFragment(eo);
        }
        return null;
    }

    @Override
    public void setID(Object element, Object id) {
        EObject eo;
        Resource resource;
        if (element instanceof EObject && (resource = (eo = (EObject)element).eResource()) instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            ATLLogger.warning((String)("Manual setting of " + EMFModelAdapter.getNameOf(eo) + ":" + eo.eClass().getName() + " XMI ID."));
            xmiResource.setID(eo, id.toString());
        }
    }

    @Override
    public boolean isModelElement(Object o) {
        return o instanceof EObject;
    }
}

