/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

@ApplicationScoped
@Path(value="nolraresource")
public class NoLRAResource {
    public static final String NO_LRA_RESOURCE_PATH = "nolraresource";
    public static final String NON_TRANSACTIONAL_WORK_PATH = "work";
    @Context
    private UriInfo context;

    @PUT
    @Path(value="work")
    public Response work2(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId != null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Unexpected LRA context").build();
        }
        WebTarget resourcePath = ClientBuilder.newClient().target(this.context.getBaseUri()).path("lraresource").path("/mandatory");
        Response response = resourcePath.request().put(Entity.text((Object)""));
        String id = this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), true, resourcePath);
        if (id == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"LRA context was not propagated").build();
        }
        return Response.ok((Object)id).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkStatusAndClose(Response response, int expected, boolean readEntity, WebTarget webTarget) {
        try {
            if (expected != -1 && response.getStatus() != expected) {
                if (webTarget != null) {
                    throw new WebApplicationException(String.format("%s: expected status %d got %d", webTarget.getUri().toString(), expected, response.getStatus()), response);
                }
                throw new WebApplicationException(response);
            }
            if (readEntity) {
                String string = (String)response.readEntity(String.class);
                return string;
            }
        }
        finally {
            response.close();
        }
        return null;
    }
}

