/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.jaxrs;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.jaxrs.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.jaxrs.ErrorCode;

public class ResourceMethodDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        String uri = context.getUri();
        IJavaElement[] elements = typeRoot.getChildren();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        String[] methodDesignators = (String[])ArrayUtils.addAll((Object[])Constants.SET_OF_METHOD_DESIGNATORS_ANNOTATIONS, (Object[])new String[]{"jakarta.ws.rs.Path"});
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return null;
            }
            if (element.getElementType() == 7 && (type = (IType)element).isClass()) {
                IMethod[] methods = type.getMethods();
                boolean isInterface = type.isInterface();
                IMethod[] iMethodArray = methods;
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    IAnnotation[] methodAnnotations = method.getAnnotations();
                    boolean isResourceMethod = false;
                    boolean isValid = true;
                    boolean isPublic = Flags.isPublic((int)method.getFlags());
                    boolean usesDfltAccessModifier = Flags.isPackageDefault((int)method.getFlags());
                    Range methodRange = PositionUtils.toNameRange(method, context.getUtils());
                    IAnnotation[] iAnnotationArray = methodAnnotations;
                    int n5 = methodAnnotations.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAnnotation annotation = iAnnotationArray[n6];
                        String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), methodDesignators);
                        if (matchedAnnotation != null) {
                            if (!(!isValid || isPublic || usesDfltAccessModifier && isInterface)) {
                                isValid = false;
                            }
                            if (!"jakarta.ws.rs.Path".equals(matchedAnnotation)) {
                                isResourceMethod = true;
                                break;
                            }
                        }
                        ++n6;
                    }
                    if (!isValid) {
                        diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnlyPublicMethods", new Object[0]), methodRange, "jakarta-jaxrs", ErrorCode.NonPublicResourceMethod, DiagnosticSeverity.Error));
                    }
                    if (isResourceMethod) {
                        ILocalVariable[] parameters;
                        int numEntityParams = 0;
                        ILocalVariable[] iLocalVariableArray = parameters = method.getParameters();
                        int n7 = parameters.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            IAnnotation[] annotations;
                            ILocalVariable param = iLocalVariableArray[n8];
                            boolean isEntityParam = true;
                            IAnnotation[] iAnnotationArray2 = annotations = param.getAnnotations();
                            int n9 = annotations.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                IAnnotation annotation = iAnnotationArray2[n10];
                                String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_NON_ENTITY_PARAM_ANNOTATIONS);
                                if (matchedAnnotation != null) {
                                    isEntityParam = false;
                                    break;
                                }
                                ++n10;
                            }
                            if (isEntityParam) {
                                ++numEntityParams;
                            }
                            ++n8;
                        }
                        if (numEntityParams > 1) {
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ResourceMethodsEntityParameter", new Object[0]), methodRange, "jakarta-jaxrs", ErrorCode.ResourceMethodMultipleEntityParams, DiagnosticSeverity.Error));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return diagnostics;
    }
}

