/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.common.ludus.backend.graph.jgrapht;

import java.io.Serializable;

/**
 * @author Bram van der Sanden
 */
public class JGraphTVertex implements Comparable<JGraphTVertex>, Serializable {
    private static final long serialVersionUID = 1L;

    Integer id;

    public JGraphTVertex() {
        this.id = this.hashCode();
    }

    /**
     * @param id vertex id
     */
    public JGraphTVertex(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return id;
    }

    @Override
    public int compareTo(JGraphTVertex other) {
        return Integer.compare(id, other.id);
    }
}
