/**
 */
package mathfunctions.util;

import expressions.AbstractElement;
import expressions.Expression;

import mathfunctions.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see mathfunctions.MathFunctionsPackage
 * @generated
 */
public class MathFunctionsSwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static MathFunctionsPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MathFunctionsSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = MathFunctionsPackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case MathFunctionsPackage.MATH_FUNCTION:
            {
                MathFunction mathFunction = (MathFunction)theEObject;
                T result = caseMathFunction(mathFunction);
                if (result == null) result = caseExpression(mathFunction);
                if (result == null) result = caseAbstractElement(mathFunction);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.MATH_FUNCTION_ONE_INPUT:
            {
                MathFunctionOneInput mathFunctionOneInput = (MathFunctionOneInput)theEObject;
                T result = caseMathFunctionOneInput(mathFunctionOneInput);
                if (result == null) result = caseMathFunction(mathFunctionOneInput);
                if (result == null) result = caseExpression(mathFunctionOneInput);
                if (result == null) result = caseAbstractElement(mathFunctionOneInput);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.MATH_FUNCTION_TWO_INPUTS:
            {
                MathFunctionTwoInputs mathFunctionTwoInputs = (MathFunctionTwoInputs)theEObject;
                T result = caseMathFunctionTwoInputs(mathFunctionTwoInputs);
                if (result == null) result = caseMathFunction(mathFunctionTwoInputs);
                if (result == null) result = caseExpression(mathFunctionTwoInputs);
                if (result == null) result = caseAbstractElement(mathFunctionTwoInputs);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.ABS_EXPRESSION:
            {
                AbsExpression absExpression = (AbsExpression)theEObject;
                T result = caseAbsExpression(absExpression);
                if (result == null) result = caseMathFunctionOneInput(absExpression);
                if (result == null) result = caseMathFunction(absExpression);
                if (result == null) result = caseExpression(absExpression);
                if (result == null) result = caseAbstractElement(absExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.EXP_EXPRESSION:
            {
                ExpExpression expExpression = (ExpExpression)theEObject;
                T result = caseExpExpression(expExpression);
                if (result == null) result = caseMathFunctionOneInput(expExpression);
                if (result == null) result = caseMathFunction(expExpression);
                if (result == null) result = caseExpression(expExpression);
                if (result == null) result = caseAbstractElement(expExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.LOG_EXPRESSION:
            {
                LogExpression logExpression = (LogExpression)theEObject;
                T result = caseLogExpression(logExpression);
                if (result == null) result = caseMathFunctionOneInput(logExpression);
                if (result == null) result = caseMathFunction(logExpression);
                if (result == null) result = caseExpression(logExpression);
                if (result == null) result = caseAbstractElement(logExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.MIN_EXPRESSION:
            {
                MinExpression minExpression = (MinExpression)theEObject;
                T result = caseMinExpression(minExpression);
                if (result == null) result = caseMathFunctionTwoInputs(minExpression);
                if (result == null) result = caseMathFunction(minExpression);
                if (result == null) result = caseExpression(minExpression);
                if (result == null) result = caseAbstractElement(minExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.MAX_EXPRESSION:
            {
                MaxExpression maxExpression = (MaxExpression)theEObject;
                T result = caseMaxExpression(maxExpression);
                if (result == null) result = caseMathFunctionTwoInputs(maxExpression);
                if (result == null) result = caseMathFunction(maxExpression);
                if (result == null) result = caseExpression(maxExpression);
                if (result == null) result = caseAbstractElement(maxExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MathFunctionsPackage.SQRT_EXPRESSION:
            {
                SqrtExpression sqrtExpression = (SqrtExpression)theEObject;
                T result = caseSqrtExpression(sqrtExpression);
                if (result == null) result = caseMathFunctionOneInput(sqrtExpression);
                if (result == null) result = caseMathFunction(sqrtExpression);
                if (result == null) result = caseExpression(sqrtExpression);
                if (result == null) result = caseAbstractElement(sqrtExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Math Function</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Math Function</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMathFunction(MathFunction object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Math Function One Input</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Math Function One Input</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMathFunctionOneInput(MathFunctionOneInput object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Math Function Two Inputs</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Math Function Two Inputs</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMathFunctionTwoInputs(MathFunctionTwoInputs object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Abs Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abs Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAbsExpression(AbsExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Exp Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Exp Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseExpExpression(ExpExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Log Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Log Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseLogExpression(LogExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Min Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Min Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMinExpression(MinExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Max Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Max Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMaxExpression(MaxExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Sqrt Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Sqrt Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSqrtExpression(SqrtExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAbstractElement(AbstractElement object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseExpression(Expression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }

} //MathFunctionsSwitch
