/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.dialog.ParameterDialog;
import org.eclipse.trace4cps.ui.view.TraceView;

public final class LittlesLawDialog
extends ParameterDialog {
    private static final String TITLE = "Little's law analysis";
    private final TraceView traceView;
    private final LlDialogType dialogType;
    private static final int N = 5;
    private final String[] keys = new String[5];
    private final String[] vals = new String[5];
    private ClaimEventType eventType = null;

    public LittlesLawDialog(Shell parentShell, TraceView view, LlDialogType type) {
        super(parentShell, LittlesLawDialog.class.getName());
        this.traceView = view;
        this.dialogType = type;
    }

    public String getIdAtt() {
        return this.getSelection().get(0);
    }

    public Map<String, String> getFilter() {
        HashMap<String, String> f = new HashMap<String, String>();
        int i = 0;
        while (i < 5) {
            if (this.keys[i] != null && this.vals[i] != null) {
                f.put(this.keys[i], this.vals[i]);
            }
            ++i;
        }
        return f;
    }

    public ClaimEventType getEventType() {
        return this.eventType;
    }

    @Override
    protected String getTitle() {
        return "Little's law analysis - " + this.dialogType.getRepresentation();
    }

    @Override
    protected boolean inputIsValid() {
        boolean ok = true;
        if (this.dialogType == LlDialogType.THROUGHPUT_EVENT) {
            int cnt = 0;
            boolean noPairs = false;
            int i = 0;
            while (i < 5) {
                if (this.keys[i] != null && this.vals[i] != null) {
                    ++cnt;
                }
                if (this.keys[i] != null && this.vals[i] == null || this.keys[i] == null && this.vals[i] != null) {
                    noPairs = true;
                }
                ++i;
            }
            boolean bl = ok = cnt > 0 && !noPairs;
        }
        return ok && super.inputIsValid();
    }

    @Override
    protected void draw(Composite composite) {
        if (this.dialogType == LlDialogType.THROUGHPUT) {
            this.drawTP(composite);
        } else if (this.dialogType == LlDialogType.LATENCY) {
            this.drawLatency(composite);
        } else if (this.dialogType == LlDialogType.WIP) {
            this.drawWip(composite);
        } else if (this.dialogType == LlDialogType.THROUGHPUT_EVENT) {
            this.drawTPevent(composite);
        } else {
            throw new IllegalStateException();
        }
        LittlesLawDialog.applyDialogFont((Control)composite);
    }

    private void createGrid1(Composite main) {
        GridLayout layout = new GridLayout(1, true);
        main.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        main.setLayoutData((Object)data);
    }

    private Composite createGrid2(Composite main) {
        Composite gr = new Composite(main, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        gr.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        gr.setLayoutData((Object)data);
        return gr;
    }

    private void drawTP(Composite main) {
        this.createGrid1(main);
        Composite sub = this.createGrid2(main);
        this.addPositiveDoubleInput(sub, true);
        this.addTimeUnitDropdown(sub, "Value scale");
        Set<String> atts = this.traceView.getAttributeNames(TracePart.CLAIM);
        this.addSelectionInput(main, "Select exactly one object grouping attribute", ParameterDialog.SelectionType.EXACTLY_ONE, atts);
    }

    private void drawTPevent(Composite main) {
        this.createGrid1(main);
        Composite sub = this.createGrid2(main);
        this.addPositiveDoubleInput(sub, false);
        this.addTimeUnitDropdown(sub, "Value scale");
        this.createFilterInput(main);
    }

    private void createFilterInput(Composite main) {
        Group group1 = new Group(main, 4);
        group1.setText("Event type");
        group1.setLayout((Layout)new GridLayout(3, true));
        group1.setLayoutData((Object)new GridData(4, 4, true, false));
        Button b1 = new Button((Composite)group1, 16);
        b1.setText("Any event");
        Button b2 = new Button((Composite)group1, 16);
        b2.setText("Start events only");
        Button b3 = new Button((Composite)group1, 16);
        b3.setText("End events only");
        if (this.eventType == null) {
            b1.setSelection(true);
        } else if (this.eventType == ClaimEventType.START) {
            b2.setSelection(true);
        } else if (this.eventType == ClaimEventType.END) {
            b3.setSelection(true);
        }
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LittlesLawDialog.this.eventType = null;
            }
        });
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LittlesLawDialog.this.eventType = ClaimEventType.START;
            }
        });
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LittlesLawDialog.this.eventType = ClaimEventType.END;
            }
        });
        Group filterGroup = new Group(main, 0);
        filterGroup.setText("Attribute filter");
        filterGroup.setLayout((Layout)new GridLayout(3, true));
        filterGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Set<String> atts = this.traceView.getAttributeNames(TracePart.EVENT);
        ArrayList<String> input = new ArrayList<String>();
        input.add("");
        input.addAll(atts);
        Collections.sort(input);
        int i = 0;
        while (i < 5) {
            final int index = i++;
            final Combo keyCombo = new Combo((Composite)filterGroup, 12);
            new Label((Composite)filterGroup, 256).setText("=");
            final Combo valCombo = new Combo((Composite)filterGroup, 12);
            keyCombo.setItems(input.toArray(new String[input.size()]));
            keyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = keyCombo.getSelectionIndex();
                    String selection = keyCombo.getItem(idx);
                    if (selection.equals("")) {
                        selection = null;
                    }
                    LittlesLawDialog.this.keys[index] = selection;
                    ArrayList<String> possibleVals = new ArrayList<String>();
                    possibleVals.add("");
                    possibleVals.addAll(LittlesLawDialog.this.traceView.getAllAttributeValuesFor(selection, TracePart.EVENT));
                    Collections.sort(possibleVals);
                    valCombo.setItems(possibleVals.toArray(new String[possibleVals.size()]));
                    LittlesLawDialog.this.checkOkButton();
                }
            });
            valCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = valCombo.getSelectionIndex();
                    String selection = valCombo.getItem(idx);
                    if (selection.equals("")) {
                        selection = null;
                    }
                    LittlesLawDialog.this.vals[index] = selection;
                    LittlesLawDialog.this.checkOkButton();
                }
            });
        }
    }

    private void drawLatency(Composite main) {
        this.createGrid1(main);
        Composite sub = this.createGrid2(main);
        this.addPositiveDoubleInput(sub, true);
        this.addTimeUnitDropdown(sub, "Value scale");
        Set<String> atts = this.traceView.getAttributeNames(TracePart.CLAIM);
        this.addSelectionInput(main, "Select exactly one object grouping attribute", ParameterDialog.SelectionType.EXACTLY_ONE, atts);
    }

    private void drawWip(Composite main) {
        this.createGrid1(main);
        Composite sub = this.createGrid2(main);
        this.addPositiveDoubleInput(sub, true);
        Set<String> atts = this.traceView.getAttributeNames(TracePart.CLAIM);
        this.addSelectionInput(main, "Select exactly one object grouping attribute", ParameterDialog.SelectionType.EXACTLY_ONE, atts);
    }

    public static enum LlDialogType {
        THROUGHPUT("identifier-based throughput"),
        THROUGHPUT_EVENT("event-based throughput"),
        LATENCY("identifier-based latency"),
        WIP("identifier-based wip");

        private final String rep;

        private LlDialogType(String r) {
            this.rep = r;
        }

        public String getRepresentation() {
            return this.rep;
        }
    }
}

