/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFCheckboxDescription;
import org.eclipse.eef.EEFCheckboxStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.common.ui.api.SWTUtils;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFCheckboxController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.EEFCheckboxStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFCheckboxLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFCheckboxDescription description;
    private Button checkbox;
    private IEEFCheckboxController controller;
    private SelectionListener selectionListener;
    private boolean referenceValue;

    public EEFCheckboxLifecycleManager(EEFCheckboxDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.checkbox = widgetFactory.createButton(parent, "", 32);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.checkbox.setLayoutData((Object)gridData);
        this.controller = new EEFControllersFactory().createCheckboxController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    @Override
    protected boolean needSeparatedLabel() {
        return false;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected Control getValidationControl() {
        return this.checkbox;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.getController().onNewLabel(value -> {
            if (!(this.checkbox.isDisposed() || this.checkbox.getText() != null && this.checkbox.getText().equals(value))) {
                this.checkbox.setText(Optional.ofNullable(value).orElse(""));
            }
        });
        this.selectionListener = SWTUtils.widgetSelectedAdapter(event -> {
            IStatus result = this.controller.updateValue(this.checkbox.getSelection());
            if (result != null && result.getSeverity() == 4) {
                EEFIdeUiPlugin.INSTANCE.log(result);
                this.checkbox.setSelection(this.referenceValue);
            } else {
                this.refresh();
            }
        });
        this.checkbox.addSelectionListener(this.selectionListener);
        this.controller.onNewValue(value -> {
            if (!this.checkbox.isDisposed() && value != null && this.checkbox.getSelection() != value.booleanValue()) {
                this.checkbox.setSelection(value.booleanValue());
                this.referenceValue = value;
            }
        });
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.checkbox.isDisposed()) {
            this.checkbox.removeSelectionListener(this.selectionListener);
        }
        this.controller.removeNewValueConsumer();
    }

    @Override
    public void refresh() {
        super.refresh();
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFCheckboxStyle) {
            EEFCheckboxStyle style = (EEFCheckboxStyle)widgetStyle;
            EEFCheckboxStyleCallback callback = new EEFCheckboxStyleCallback(this.checkbox);
            styleHelper.applyTextStyle(style.getLabelFontNameExpression(), style.getLabelFontSizeExpression(), style.getLabelFontStyleExpression(), this.checkbox.getFont(), style.getLabelBackgroundColorExpression(), style.getLabelForegroundColorExpression(), callback);
        }
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.checkbox.isDisposed()) {
            this.checkbox.setEnabled(isEnabled);
        }
    }
}

