/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.app.command.CommandCloudApp;
import org.eclipse.kura.cloud.app.command.KuraCommandRequestPayload;
import org.eclipse.kura.cloud.app.command.KuraCommandResponsePayload;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.command.api.RestCommandRequest;
import org.eclipse.kura.rest.command.api.RestCommandResponse;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/command/v1")
public class CommandRestService {
    private static final Logger logger = LoggerFactory.getLogger(CommandRestService.class);
    private static final String KURA_PERMISSION_REST_CONFIGURATION_ROLE = "kura.permission.rest.command";
    private static final String PASSWORD_METRIC_NAME = "command.password";
    public static final String RESOURCE_COMMAND = "command";
    private CommandCloudApp commandCloudApp;

    public void setUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_CONFIGURATION_ROLE, 2);
    }

    public void setCommandCloudApp(CommandCloudApp commandCloudApp) {
        this.commandCloudApp = commandCloudApp;
    }

    @POST
    @RolesAllowed(value={"command"})
    @Path(value="/command")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RestCommandResponse execCommand(RestCommandRequest restCommandPayload) {
        try {
            return this.doExecCommand(restCommandPayload);
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @POST
    @RolesAllowed(value={"command"})
    @Path(value="/command/async")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response execAsyncCommand(RestCommandRequest restCommandPayload) {
        try {
            return this.doExecAsyncCommand(restCommandPayload);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    private RestCommandResponse doExecCommand(RestCommandRequest restCommandPayload) throws KuraException {
        return this.buildRestCommandResponse(this.commandCloudApp.doExec(null, this.buildKuraMessage(restCommandPayload, false)));
    }

    private Response doExecAsyncCommand(RestCommandRequest restCommandPayload) throws KuraException {
        try {
            this.commandCloudApp.doExec(null, this.buildKuraMessage(restCommandPayload, true));
            return Response.accepted().build();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    private KuraMessage buildKuraMessage(RestCommandRequest restCommandPayload, boolean isAsync) {
        KuraCommandRequestPayload kuraCommandRequestPayload = new KuraCommandRequestPayload(restCommandPayload.getCommand());
        kuraCommandRequestPayload.addMetric(PASSWORD_METRIC_NAME, (Object)restCommandPayload.getPassword());
        kuraCommandRequestPayload.setZipBytes(restCommandPayload.getZipBytesAsByteArray());
        kuraCommandRequestPayload.setWorkingDir(restCommandPayload.getWorkingDirectory());
        kuraCommandRequestPayload.setArguments(restCommandPayload.getArguments());
        kuraCommandRequestPayload.setEnvironmentPairs(restCommandPayload.getEnvironmentPairsAsStringArray());
        kuraCommandRequestPayload.setRunAsync(isAsync);
        HashMap<String, List<String>> payloadProperties = new HashMap<String, List<String>>();
        payloadProperties.put(RequestHandlerMessageConstants.ARGS_KEY.value(), Arrays.asList(RESOURCE_COMMAND));
        return new KuraMessage((KuraPayload)kuraCommandRequestPayload, payloadProperties);
    }

    private RestCommandResponse buildRestCommandResponse(KuraMessage kuraMessage) throws KuraException {
        if (kuraMessage.getPayload() instanceof KuraCommandResponsePayload) {
            RestCommandResponse restCommandResponse = new RestCommandResponse();
            KuraCommandResponsePayload kuraCommandResponsePayload = (KuraCommandResponsePayload)kuraMessage.getPayload();
            restCommandResponse.setStdout(kuraCommandResponsePayload.getStdout());
            restCommandResponse.setStderr(kuraCommandResponsePayload.getStderr());
            restCommandResponse.setExitCode(kuraCommandResponsePayload.getExitCode());
            restCommandResponse.setIsTimeOut(kuraCommandResponsePayload.isTimedout());
            return restCommandResponse;
        }
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
    }
}

