/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.system;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperSystemService {
    private static final Logger logger = LoggerFactory.getLogger(SuperSystemService.class);

    protected static String runSystemCommand(String[] commandLine, boolean runInShell, CommandExecutorService executorService, boolean allowFailure) {
        String response = "";
        Command command = new Command(commandLine);
        command.setTimeout(60);
        command.setOutputStream((OutputStream)new ByteArrayOutputStream());
        command.setExecuteInAShell(runInShell);
        CommandStatus status = executorService.execute(command);
        if (status.getExitStatus().isSuccessful() || allowFailure) {
            response = new String(((ByteArrayOutputStream)status.getOutputStream()).toByteArray(), StandardCharsets.UTF_8);
        } else if (logger.isErrorEnabled()) {
            logger.error("failed to run commands {}", (Object)String.join((CharSequence)" ", commandLine));
        }
        return response;
    }

    protected static String runSystemCommand(String[] commandLine, boolean runInShell, CommandExecutorService executorService) {
        return SuperSystemService.runSystemCommand(commandLine, runInShell, executorService, false);
    }

    protected static String runSystemCommand(String commandLine, boolean runInShell, CommandExecutorService executorService, boolean allowFailure) {
        return SuperSystemService.runSystemCommand(commandLine.split("\\s+"), runInShell, executorService, allowFailure);
    }

    protected static String runSystemCommand(String commandLine, boolean runInShell, CommandExecutorService executorService) {
        return SuperSystemService.runSystemCommand(commandLine.split("\\s+"), runInShell, executorService);
    }
}

