/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.regexfilter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.regexfilter.FilterType;
import org.eclipse.kura.util.collection.CollectionUtil;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public final class RegexFilter
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(RegexFilter.class);
    private static final String REGEX_PROP = "regex.filter";
    private static final String REGEX_TYPE_PROP = "filter.type";
    private WireSupport wireSupport;
    private String filter;
    private FilterType filterType;
    private String componentPid;
    private volatile WireHelperService wireHelperService;

    protected synchronized void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    protected synchronized void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected synchronized void activate(Map<String, Object> properties, ComponentContext componentContext) {
        logger.debug("Activating Regex Filter...");
        this.filter = String.valueOf(properties.getOrDefault(REGEX_PROP, ""));
        this.componentPid = String.valueOf(properties.get("kura.service.pid"));
        this.filterType = RegexFilter.getType(properties);
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        logger.debug("Activating Regex Filter... Done");
    }

    protected synchronized void updated(Map<String, Object> properties) {
        logger.debug("Updating Regex Filter...");
        this.filter = String.valueOf(properties.getOrDefault(REGEX_PROP, ""));
        this.filterType = RegexFilter.getType(properties);
        logger.debug("Updating Regex Filter... Done");
    }

    public synchronized void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public synchronized void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public synchronized Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public synchronized void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        List receivedRecords = wireEnvelope.getRecords();
        if (Objects.isNull(this.filter) || this.filter.trim().isEmpty()) {
            this.wireSupport.emit(receivedRecords);
            return;
        }
        WireEnvelope filteredWireEnvelope = this.getFilteredWireEnvelope(receivedRecords, wireEnvelope);
        this.wireSupport.emit(filteredWireEnvelope.getRecords());
    }

    private WireEnvelope getFilteredWireEnvelope(List<WireRecord> wireRecords, WireEnvelope nonFilteredWireEnvelope) {
        WireEnvelope filteredWireEnvelope;
        try {
            filteredWireEnvelope = new WireEnvelope(this.componentPid, RegexFilter.filter(wireRecords, this.filter, this.filterType));
        }
        catch (Exception ex) {
            logger.warn("Error while filtering using provided Regular Expression...", (Throwable)ex);
            filteredWireEnvelope = nonFilteredWireEnvelope;
        }
        return filteredWireEnvelope;
    }

    private static List<WireRecord> filter(List<WireRecord> wireRecords, String filter, FilterType type) {
        Objects.requireNonNull(wireRecords, "Wire Records cannot be null");
        Objects.requireNonNull(filter, "Filter cannot be null");
        List filteredWireRecords = CollectionUtil.newArrayList();
        for (WireRecord wireRecord : wireRecords) {
            Map filteredProperties;
            Map previousProperties = wireRecord.getProperties();
            if (previousProperties == (filteredProperties = RegexFilter.match(filter, previousProperties, type))) {
                filteredWireRecords.add(wireRecord);
                continue;
            }
            WireRecord newWireRecord = new WireRecord(filteredProperties);
            filteredWireRecords.add(newWireRecord);
        }
        return filteredWireRecords;
    }

    private static <V> Map<String, V> match(String regularExpression, Map<String, V> map, FilterType type) {
        if (map.isEmpty()) {
            return map;
        }
        Pattern pattern = Pattern.compile(regularExpression);
        Set<Map.Entry<String, V>> entrySet = map.entrySet();
        Supplier<Stream> streamSupplier = entrySet::stream;
        boolean allMatch = streamSupplier.get().allMatch(RegexFilter.matches(pattern, type));
        if (allMatch) {
            return type == FilterType.RETAIN ? map : Collections.unmodifiableMap(CollectionUtil.newHashMap());
        }
        return streamSupplier.get().filter(RegexFilter.matches(pattern, type)).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));
    }

    private static <V> Predicate<Map.Entry<String, V>> matches(Pattern pattern, FilterType type) {
        Predicate<Map.Entry<String, V>> predicate = entry -> pattern.matcher((CharSequence)entry.getKey()).matches();
        return type == FilterType.RETAIN ? predicate : predicate.negate();
    }

    private static FilterType getType(Map<String, Object> props) {
        int type = (Integer)props.getOrDefault(REGEX_TYPE_PROP, 1);
        return type == 2 ? FilterType.REMOVE : FilterType.RETAIN;
    }
}

